<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY mdash "&#8212;">
  <!ENTITY bull "&#8226;">
]>
	<!-- 09/04/2024 - 993082/992049 - AJH -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="PopulateTemplate.xsl" />
	<xsl:include href="AddHeader.xsl" />
	<xsl:include href="CommonPathRef.xsl" />
	<xsl:include href="AddOnTable.xsl" />
	<xsl:include href="IRS8933ScheduleFStyle.xsl" />
	<xsl:output method="html" indent="yes" />
	<xsl:strip-space elements="*" />
	<xsl:param name="FormData" select="$RtnDoc/IRS8933ScheduleF" />
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html lang="EN-US">
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge" />
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($FormData)" />
					</xsl:call-template>
				</title>
				<!-- No Browser Caching -->
				<meta http-equiv="Pragma" content="no-cache" />
				<meta http-equiv="Cache-Control" content="no-cache" />
				<meta http-equiv="Expires" content="0" />
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private" />
				<!-- Define Character Set -->
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
				<meta name="Description" content="IRS Form 8933 ScheduleF" />
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript" />
				<xsl:call-template name="InitJS" />
				<style type="text/css">
					<xsl:if test="not($Print) or $Print=''">
						<xsl:call-template name="IRS8933ScheduleFStyle" />
						<xsl:call-template name="AddOnStyle" />
					</xsl:if>
				</style>
				<xsl:call-template name="GlobalStylesForm" />
			</head>
			<body class="styBodyClass" style="width:256mm;">
				<form id="Form8933ScheduleF">
					<xsl:call-template name="DocumentHeaderLandscape" />
					<!-- Page 1 -->
					<!-- Header -->
					<div class="styStdDivLS">
						<div class="styFNBox" style="width:30mm;height:22mm;">
							<span class="styFN" style="font-size:8pt;">SCHEDULE F <br/>(Form 8933)</span> 
							<br /><br />
							(December 2024)
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData" />
							</xsl:call-template>
							<br />
							<span class="styAgency" style="padding-bottom:1mm;padding-top:2mm;">
								Department of the Treasury <br />
								Internal Revenue Service
							</span>
						</div>
						<div class="styFTBox" style="width:180mm;">
							<div class="styMainTitle" style="padding-top:2mm;">Utilization Certification</div>
							<br /><br />
							<span style="font-weight:bold;padding-top:2mm;">
								Attach to Form 8933.
							</span><br />
							<span style="font-weight:bold;">
								Go to
								<span style="font-style:italic">www.irs.gov/Form8933 </span> for instructions and the latest information.
							</span>
						</div>
						<div class="styTYBox" style="width:30mm;height:22mm;">
							<div class="styOMB" style="height:auto;padding-top:9mm;border-bottom:0px;">OMB No. 1545-2132</div>
						</div>
					</div>
					<!-- Filer information section -->
					<div class="styStdDivLS" style="border-top:1px solid black;">
						<div class="styNameBox" style="width:200mm;">
							Name(s) shown on return<br />
							<xsl:call-template name="PopulateReturnHeaderFiler">
								<xsl:with-param name="TargetNode">BusinessNameLine1Txt</xsl:with-param>
							</xsl:call-template><br />
							<xsl:call-template name="PopulateReturnHeaderFiler">
								<xsl:with-param name="TargetNode">BusinessNameLine2Txt</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="styEINBox" style="width:56mm;padding-left:0.5mm;font-weight:normal;">
							<strong>Identifying number</strong><br />
							<xsl:call-template name="PopulateReturnHeaderFilerTIN"/>
						</div>
					</div>
					<!-- Part I -->
					<div class="styStdDivLS" style="border-top:1px solid black;">
						<div class="styPartName">Part I</div>
						<div class="styPartDesc">
							Information About the Qualified Carbon Utilization Facility and Utilization of Carbon Oxide 
						</div>
					</div>
					<div class="styStdDivLS" style="border-top:1px solid black;border-bottom-width:0.3px;">
						<div class="styLNDescLandscape" style="font-weight:bold;">
							Section 1&mdash;Information about owner or lessee(s) of the carbon utilization facility and utilization of qualified carbon oxide at this facility
						</div>
					</div>
					<!-- Part I Line 1 -->
					<div class="styStdDivLS" style="border-top:1px solid black;height:12mm;border-bottom-width:0px;">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="styLNDescLandscape" style="font-size:7.5pt;width:230mm;">
							Provide information about each owner or lessee of the carbon oxide utilization facility during the calendar year. <br/>
							&bull; If there're more than four owners or lessees, prepare a separate schedule with all the owner or lessee information and attach it to this certificate. <br/>
							&bull; If one or more of the owners is a partnership or an S corporation, provide information about the pass-through entity, not about the partners or shareholders.
						</div>
					</div>
					<div class="styStdDivLS" style="border-top:1px solid black;">
						<div class="styGenericDiv" style="width:3.2mm;text-align:right;"></div>
					</div>
					<!-- Part I Section 1 table -->
					<xsl:variable name="shouldSeparateP1T1" select="($Print = $Separated) and (count($FormData/OwnerOrLesseeCrbnUtlzFcltyGrp) &gt; 4)"/>
					<div class="styTableContainerLandscape" style="width:256mm;border-bottom-width:0px;" id="Part1Table1">
						<xsl:call-template name="SetInitialState"/>
						<table class="styTable" style="font-size:7pt;border-collapse:collapse;">
							<thead class="styTableThead" style="height:12mm;">
								<tr>
									<th class="styTableCellHeader" scope="col" style="width:5mm;font-weight:normal;border-right-width:0px;">&nbsp;</th>
									<th class="styTableCellHeader" scope="col" style="width:60mm;font-weight:normal;vertical-align:top;padding-top:5px;">
										<strong>(i)</strong> Name
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;vertical-align:top;padding-top:5px;">
										<strong>(ii)</strong> Owner/ <br /> Lessee
									</th>
									<th class="styTableCellHeader" scope="col" style="width:116mm;font-weight:normal;vertical-align:top;padding-top:5px;">
										<strong>(iii)</strong> Address
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;vertical-align:top;padding-top:5px;">
										<strong>(iv)</strong> Employer<br /> identification <br /> number (EIN)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;border-right-width:0px;vertical-align:top;padding-top:5px;">
										<strong>(v)</strong> Operating <br /> interest (%)
									</th>
								</tr>
							</thead>						
							<tbody>
								<xsl:if test="not($shouldSeparateP1T1)">
								<xsl:for-each select="$FormData/OwnerOrLesseeCrbnUtlzFcltyGrp">
									<tr>
										<td class="styTableCellCtrInherit" style="font-weight:bold;border-right-width:0px;">
											<xsl:number format="A" value="position()"/>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:choose>
												<xsl:when test="FacilityOwnerPersonNm">											
													<xsl:call-template name="PopulateText">
														<xsl:with-param name="TargetNode" select="FacilityOwnerPersonNm"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>	
													<xsl:call-template name="PopulateText">
														<xsl:with-param name="TargetNode" select="FacilityOwnerBusinessName/BusinessNameLine1Txt"/>
													</xsl:call-template>
													<xsl:if test="FacilityOwnerBusinessName/BusinessNameLine2Txt">
														<br/>
														<xsl:call-template name="PopulateText">
															<xsl:with-param name="TargetNode" select="FacilityOwnerBusinessName/BusinessNameLine2Txt"/>
														</xsl:call-template>
													</xsl:if>													
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="OwnerOrLesseeCd" />
											</xsl:call-template>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:choose>
												<xsl:when test="FacilityOwnerUSAddress">
													<xsl:call-template name="PopulateUSAddressTemplate">
														<xsl:with-param name="TargetNode" select="FacilityOwnerUSAddress" />
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="PopulateForeignAddressTemplate">
														<xsl:with-param name="TargetNode" select="FacilityOwnerForeignAddress" />
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>										
										</td>
										<td class="styTableCellTextInherit">
											<xsl:choose>
												<xsl:when test="FacilityOwnerSSN">										
													<xsl:call-template name="PopulateSSN">
														<xsl:with-param name="TargetNode" select="FacilityOwnerSSN"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="PopulateEIN">									
														<xsl:with-param name="TargetNode" select="FacilityOwnerEIN"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="styTableCellAmtInherit" style="border-right-width:0px;">
											<xsl:call-template name="PopulateAmount">
												<xsl:with-param name="TargetNode" select="OperatingInterestPct" />
											</xsl:call-template>
										</td>
									</tr>
								</xsl:for-each>
								</xsl:if>
								<xsl:if test="$shouldSeparateP1T1 or count($FormData/OwnerOrLesseeCrbnUtlzFcltyGrp) &lt; 4">
									<xsl:call-template name="FillPart1Table1">
										<xsl:with-param name="LineNumber" select="count($FormData/OwnerOrLesseeCrbnUtlzFcltyGrp) + 1"/>
										<xsl:with-param name="MaxLine" select="4"/>
										<xsl:with-param name="SepMessage" select="$shouldSeparateP1T1"/>
									</xsl:call-template>
								</xsl:if>
							</tbody>		
						</table>
					</div>						
					<!-- Part I Line 2 -->
					<div class="styStdDivLS">
						<div class="styLNLeftNumBoxSD" style="width:10mm;">2</div>
						<div class="styLNDescLandscape" style="height:10mm;">
							Name of the utilization facility<br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityName/BusinessNameLine1Txt"/>
							</xsl:call-template>
							<xsl:if test="$FormData/FacilityName/BusinessNameLine2Txt">
								<br/>
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/FacilityName/BusinessNameLine2Txt"/>
								</xsl:call-template>	
							</xsl:if>
						</div>
					</div>
					<!-- Part I Line 3 -->
					<div class="styStdDivLS" style="border-top:1px solid black;">
						<div class="styLNLeftNumBoxSD" style="width:10mm;">3</div>
						<div class="styLNDescLandscape" style="height:auto">
							Location of the utilization facility (street, county, and state)<br/>
							<xsl:call-template name="PopulateUSAddressTemplate">
								<xsl:with-param name="TargetNode" select="$FormData/LocationAddressInUS"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part I Line 4 -->
					<div class="styStdDivLS" style="border-top:1px solid black;">
						<div class="styLNLeftNumBoxSD" style="width:10mm;">4</div>
						<div class="styLNDescLandscape" style="height:auto;">
							Registered owner or operator<br/>
							<xsl:call-template name="FillBusinessName">
								<xsl:with-param name="TargetBusinessName" select="$FormData/RegisteredOwnerOrOperatorName"/>
							</xsl:call-template>
						</div>
					</div>				
					<!-- Part I Line 5 -->
					<div class="styStdDivLS" style="border-top:1px solid black;border-bottom:1px solid black;">
						<div class="styLNLeftNumBoxSD" style="width:10mm;">5</div>
						<div class="styLNDescLandscape" style="width=256mm;">
							Provide information about utilization of qualified carbon oxide at this facility below.
						</div>				
						<!-- Line 5 a, b, c-->
						<div class="styStdDivLS" id="IBActn" style="border-bottom-width:0px;padding-top:2mm;">
							<table class="styTableContainerLandscape" cellspacing="0" style="width:256mm;padding-left:4mm;border-bottom-width:0px;">
								<thead class="styTableThead">
									<tr>
										<th class="styTableCellHeader" scope="col" style="width:5mm;border-right-width:0px;text-align:left;padding-bottom:2mm;border-bottom-width:0px;"></th>									
										<th class="styTableCellHeader" scope="col" style="width:75mm;font-weight:normal;border-right-width:0px;text-align:left;padding-bottom:2mm;">
											Check all that apply.
										</th>
										<th class="styTableCellHeader" scope="col" style="font-weight:normal;border-right-width:0px;text-align:left;padding-bottom:2mm;">
											Describe in more detail how the qualified carbon oxide is utilized.
										</th>
									</tr>
								</thead>
								<tbody>					
									<tr>
										<td><span style="width:5mm;font-weight:bold;vertical-align:top;float:left;height:15mm;padding-top:1mm;">a</span></td>
										<td class="styTableCellCtrInherit" style="width:75mm;vertical-align:top;padding-top:1mm;">										
											<span style="float:left;font-weight:normal;">
												<input type="checkbox" class="styCkboxNM" alt="FixationInd" aria-label="Fixation">
													<xsl:call-template name="PopulateCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/FixationInd"/>
														<xsl:with-param name="BackupName">Form8933SchFFixationInd</xsl:with-param>
													</xsl:call-template>
												</input>
											</span>
											<span style="padding-top.5mm;text-align:left;">Fixation through photosynthesis or chemosynthesis, such as <br/>
												through the growing of algae or bacteria.  
											</span>										
										</td>
										<td class="styTableCellCtrInherit" style="vertical-align:top;width:146mm;border-right-width:0px;height:15mm;text-align:left;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" 
												select="$FormData/FixationDesc"/>
											</xsl:call-template>										
										</td>
									</tr>
									<tr>
										<td><span style="width:5mm;font-weight:bold;vertical-align:top;float:left;height:15mm;padding-top:1mm;">b</span></td>
										<td class="styTableCellCtrInherit" style="width:75mm;vertical-align:top;padding-top:1mm;">										
											<span style="float:left;font-weight:normal;text-align:left;">
												<input type="checkbox" class="styCkboxNM" style="margin:1px 1px 1px 1px;" alt="ChemicalConversionInd" aria-label="Chemical Conversion">
													<xsl:call-template name="PopulateCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ChemicalConversionInd"/>
														<xsl:with-param name="BackupName">Form8933SchFChemicalConversionInd</xsl:with-param>
													</xsl:call-template>
												</input>
											</span>
											<span style="padding-top.5mm;text-align:left;">Chemical conversion to a material or chemical compound in <br/>
												 which qualified carbon oxide is securely stored.
											</span>
										</td>
										<td class="styTableCellCtrInherit" style="vertical-align:top;width:146mm;border-right-width:0px;height:15mm;text-align:left;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" 
												select="$FormData/ChemicalConversionDesc"/>
											</xsl:call-template>										
										</td>
									</tr>
									<tr>
										<td><span style="width:5mm;font-weight:bold;vertical-align:top;float:left;height:15mm;padding-top:1mm;">c</span></td>
										<td class="styTableCellCtrInherit" style="width:75mm;vertical-align:top;padding-top:1mm;">									
											<span style="float:left;font-weight:normal;text-align:left;">
												<input type="checkbox" class="styCkboxNM" style="margin:1px 1px 1px 1px;" alt="OtherPurposeInd" aria-label="Other Purpose">
													<xsl:call-template name="PopulateCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/OtherPurposeInd"/>
														<xsl:with-param name="BackupName">Form8933SchFOtherPurposeInd</xsl:with-param>
													</xsl:call-template>
												</input>
											</span>
											<span style="padding-top.5mm;text-align:left;">For any other purpose for which a commercial market exists <br/>
												(with the exception of use as a tertiary injectant in a qualified <br/>
												enhanced oil or natural gas recovery project), as determined<br/>
												by regulations or other official guidance.
											</span>
										</td>
										<td class="styTableCellCtrInherit" style="vertical-align:top;width:146mm;border-right-width:0px;height:15mm;text-align:left;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" 
												select="$FormData/OtherPurposeDesc"/>
											</xsl:call-template>										
										</td>
									</tr>		
								</tbody>
							</table>
						</div>
						<div class="styStdDivLS" style="padding-top:2mm;">
							<span style="width:10mm;"></span>
							<div style="width:225mm;"><strong>(1)</strong> Do you attest that a commercial market exists for your particular product, process, or service?
								<span class="sty8933SchFDotLn">.........................</span>
							</div>	
							<span>
							<xsl:call-template name="PopulateSpan">
								<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
							</xsl:call-template>							
							<input type="Checkbox" class="styCkboxNM" alt="Attestmemt indicator Yes" aria-label="Attestment Letter Attached Yes">
								<xsl:call-template name="PopulateYesCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
									<xsl:with-param name="BackupName">Form8933SchFAttestmentLetterAttachedInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:1mm;"/>	
							<strong>Yes</strong>
							<span style="width:3mm;"/>								
							<input type="Checkbox" class="styCkboxNM" alt="Attestmemt indicator No" aria-label="Attestment Letter Attached No">
								<xsl:call-template name="PopulateNoCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
									<xsl:with-param name="BackupName">Form8933SchFAttestmentLetterAttachedInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:1mm;"/>
							</span>
							<strong>No</strong>
						</div>
						<div class="styStdDivLS" style="padding-top:2mm;">
							<span style="width:10mm;"></span>
							<div style="width:225mm;"><strong>(2)</strong> Have you attached a statement substantiating that a commercial market exists? Don't complete this certificate unless you answered "Yes" to the </div>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/AttachedStatementInd"/>
							</xsl:call-template><br/>
							<span style="width:15mm;"></span>
							<div style="width:220mm;">questions on lines 5c(1) and 5c(2). See instructions<span class="sty8933SchFDotLn">.....................................</span></div>
							<span>
							<xsl:call-template name="PopulateSpan">
								<xsl:with-param name="TargetNode" select="$FormData/AttachedStatementInd"/>
							</xsl:call-template>							
							<input type="Checkbox" class="styCkboxNM" alt="Attached Statement indicator Yes" aria-label="Attached Statement Yes">
								<xsl:call-template name="PopulateYesCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AttachedStatementInd"/>
									<xsl:with-param name="BackupName">Form8933SchFAttachedStatementInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:1mm;"/>	
							<strong>Yes</strong>
							<span style="width:3mm;"/>								
							<input type="Checkbox" class="styCkboxNM" alt="Attached Statement indicator No" aria-label="Attached Statement No">
								<xsl:call-template name="PopulateNoCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AttachedStatementInd"/>
									<xsl:with-param name="BackupName">Form8933SchFAttachedStatementInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:1mm;"/>
							</span>
							<strong>No</strong>						
						</div>
					</div>
					<!-- Page 1 FOOTER-->
					<div style="width:256mm;">
						<div style="float: left; clear: none;">
							<span class="styBoldText">
							For Paperwork Reduction Act Notice, see the Instructions for Form 8933.</span>
						</div>
						<div style="float:right">
							Cat. No. 94877J
							<span style="width:140px;"/>
							<b>Schedule F (Form 8933) (12-2024)</b>
						</div>
					</div>
					<div class="pageEnd"/>
					<!-- Page 2 HEADER-->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div style="float: left; clear: none">Schedule F (Form 8933) (12-2024) </div>						
						<div style="float:right">
							Page <span class="styBoldText" style="font-size: 8pt">2</span>
						</div>
					</div>
					<!-- Part I Continued-->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styPartName">Part I</div>
						<div class="styPartDesc">
							Information About the Qualified Carbon Utilization Facility and Utilization of Carbon Oxide <span style="font-weight:normal;"><i>(Continued)</i></span>
						</div>
					</div>
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styLNDescLandscape" style="font-weight:bold;">
							Section 2&mdash;Information about the qualified carbon oxide supplied to the utilization facility
						</div>
					</div>
					<!-- Part I Line 6 -->
					<div class="styStdDivLS" style="height:15mm;">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="styLNDescLandscape" style="width:236mm;font-size:7.5pt;">
							Provide information about all suppliers of qualified carbon oxide during the calendar year. "Qualified" carbon oxide means carbon oxide from a supplier who attests that the <br/>
							carbon oxide was captured at one of its section 45Q facilities. "Supplier" means the person who captured the qualified carbon oxide, which may differ from the company <br/>
							that sold the carbon oxide or physically delivered the carbon oxide to the owner of the utilization facility. If there're more than three suppliers of qualified carbon oxide to the <br/>
							utilization facility, prepare a separate table with all the information and attach it to this certificate.
						</div>
					</div>
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styGenericDiv" style="width:3.2mm;text-align:right;"></div>
					</div>
					<!-- Part I Section 2 table 1 -->
					<xsl:variable name="shouldSeparateP1T2" select="($Print = $Separated) and (count($FormData/QlfyCrbnOxdUtlzFcltyGrp) &gt; 3)"/>
					<div class="styTableContainerLandscape" style="width:256mm;border-bottom-width:0px;" id="Part1Table2">
						<xsl:call-template name="SetInitialState"/>
						<table class="styTable" style="font-size:7pt;border-collapse:collapse;">	
							<thead class="styTableThead" style="height:15mm;">
								<tr>
									<th class="styTableCellHeader" scope="col" style="width:5mm;font-weight:normal;border-right-width:0px;">&nbsp;</th>
									<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;vertical-align:top;padding-top:10px;">
										<strong>(i)</strong> Qualified carbon <br/> oxide supplier
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;vertical-align:top;padding-top:10px;">
										<strong>(ii)</strong> EIN
									</th>
									<th class="styTableCellHeader" scope="col" style="width:50mm;font-weight:normal;vertical-align:top;padding-top:10px;">
										<strong>(iii)</strong> Name of <br/> capture facility
									</th>
									<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;vertical-align:top;padding-top:10px;">
										<strong>(iv)</strong> Location of<br /> capture facility <br /> (county and state)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:50mm;font-weight:normal;vertical-align:top;padding-top:10px;">
										<strong>(v)</strong> IRS-issued registration <br /> number
									</th>
									<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;vertical-align:top;padding-top:10px;">
										<strong>(vi)</strong> EPA <br /> e-GGRT <br /> ID number(s)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;border-right-width:0px;vertical-align:top;padding-top:10px;">
										<strong>(vii)</strong> Check if <br /> supplier <br /> supplied any <br /> nonqualified <br /> carbon oxide
									</th>
								</tr>
							</thead>						
							<tbody>
							<xsl:if test="not($shouldSeparateP1T2)">
								<xsl:for-each select="$FormData/QlfyCrbnOxdUtlzFcltyGrp">
									<tr>
										<td class="styTableCellCtrInherit" style="vertical-align:middle;font-weight:bold;border-right-width:0px;">
											<xsl:number format="A" value="position()"/>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="SupplierName/BusinessNameLine1Txt"/>
											</xsl:call-template>
											<br/>
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="SupplierName/BusinessNameLine2Txt"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateEIN">
												<xsl:with-param name="TargetNode" select="SupplierEIN" />
											</xsl:call-template>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="FacilityName/BusinessNameLine1Txt"/>
											</xsl:call-template>
											<br/>
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="FacilityName/BusinessNameLine2Txt"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="LocationTxt" />
											</xsl:call-template>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="FacilityIRSIssdRegistrationNum" />
											</xsl:call-template>
										</td>
										<td class="styTableCellTextInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="FacilityEPAeGGRTIdNum" />
											</xsl:call-template>
										</td>
										<td class="styTableCellCtrInherit" style="border-right-width:0px;">										
											<input class="styCkbox" type="checkbox" alt="Non qualified carbon oxide supplier indicator">
													<xsl:attribute name="aria-label">
														Row <xsl:number format="A" value="position()"/>, Non qualified carbon oxide supplier
													</xsl:attribute>
												<xsl:call-template name="PopulateCheckbox">
													<xsl:with-param name="TargetNode" select="NonQlfyCrbnOxdSupplierInd"/>
													<xsl:with-param name="BackupName">Form8933SchFNonQlfyCrbnOxdSupplierInd<xsl:value-of select="position()"/></xsl:with-param>
												</xsl:call-template>
											</input>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="$shouldSeparateP1T2 or count($FormData/QlfyCrbnOxdUtlzFcltyGrp) &lt; 1">
								<tr>
									<td class="styTableCellTextInherit" style="border-right-width:0px;">
										<span style="font-weight:bold;width:5mm;">A</span>
									</td>
									<td class="styTableCellCtrInherit">
										<xsl:if test="$shouldSeparateP1T2">
											See additional data table
										</xsl:if>
									</td>
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>	
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>	
									<td class="styTableCellCtrInherit" style="border-right-width:0px;">
										<input type="checkbox" class="styCkbox">
											<xsl:attribute name="aria-label">Row A, Non qualified carbon oxide supplier</xsl:attribute>
											<xsl:call-template name="PopulateCheckbox">
												<xsl:with-param name="TargetNode" select="/.."/>
												<xsl:with-param name="BackupName">Form8933SchFNonQlfyCrbnOxdSupplierInd1</xsl:with-param>
											</xsl:call-template>
										</input>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="$shouldSeparateP1T2 or count($FormData/QlfyCrbnOxdUtlzFcltyGrp) &lt; 2">
								<tr>
									<td class="styTableCellTextInherit" style="border-right-width:0px;">
										<span style="font-weight:bold;width:5mm;">B</span>
									</td>
									<td class="styTableCellCtrInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>	
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>	
									<td class="styTableCellCtrInherit" style="border-right-width:0px;">
										<input type="checkbox" class="styCkbox">
											<xsl:attribute name="aria-label">Row B, Non qualified carbon oxide supplier</xsl:attribute>
											<xsl:call-template name="PopulateCheckbox">
												<xsl:with-param name="TargetNode" select="/.."/>
												<xsl:with-param name="BackupName">Form8933SchFNonQlfyCrbnOxdSupplierInd2</xsl:with-param>
											</xsl:call-template>
										</input>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="$shouldSeparateP1T2 or count($FormData/QlfyCrbnOxdUtlzFcltyGrp) &lt; 3">
								<tr>
									<td class="styTableCellTextInherit" style="border-right-width:0px;">
										<span style="font-weight:bold;width:5mm;">C</span>
									</td>
									<td class="styTableCellCtrInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>	
									<td class="styTableCellTextInherit">&nbsp;</td>
									<td class="styTableCellTextInherit">&nbsp;</td>	
									<td class="styTableCellCtrInherit" style="border-right-width:0px;">
										<input type="checkbox" class="styCkbox">
											<xsl:attribute name="aria-label">Row C, Non qualified carbon oxide supplier</xsl:attribute>
											<xsl:call-template name="PopulateCheckbox">
												<xsl:with-param name="TargetNode" select="/.."/>
												<xsl:with-param name="BackupName">Form8933SchFNonQlfyCrbnOxdSupplierInd3</xsl:with-param>
											</xsl:call-template>
										</input>
									</td>
								</tr>
							</xsl:if>
							</tbody>		
						</table>
					</div>
					<!-- Part I Line 7 -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;height:auto;">
						<div class="styLNLeftNumBoxSD">7</div>
						<div class="styLNDescLandscape" style="height:auto;">
							List all suppliers of nonqualified carbon oxide <br/>
							<xsl:for-each select="$FormData/SupplierBusinessName">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="./BusinessNameLine1Txt"/>
								</xsl:call-template>
								<xsl:if test="$FormData/SupplierBusinessName/BusinessNameLine2Txt">
									<span style="width:3mm"/>
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="./BusinessNameLine2Txt"/>
									</xsl:call-template>									
								</xsl:if>
								<br/>
							</xsl:for-each>
						</div>
					</div>
					<!-- Part I Line 8 -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;padding-bottom:12px;height:9mm;">
						<div class="styLNLeftNumBoxSD">8</div>
						<div class="styLNDescLandscape" style="width:246mm;font-size:7.5pt;">
							Provide utilization information that conforms to the Life Cycle Assessment (LCA) that was approved by the Department of Energy (DOE) and the IRS. If there're more than <br />
							four owners of the utilization facility or three suppliers of qualified carbon oxide, prepare a separate table with all the information and attach it to this certificate.
						</div>
					</div>
					<!-- Part I Section 2 table 2 -->
					<xsl:variable name="shouldSeparateP1T3" select="($Print = $Separated) and (count($FormData/OwnerLesseeUtlzFcltyLCAGrp) &gt; 4)"/>
					<div class="styTableContainerLandscape" style="width:256mm;border-bottom-width:0px;" id="Part1Table3">
						<xsl:call-template name="SetInitialState"/>
						<table class="styTable" style="font-size:7pt;border-collapse:collapse;">	
							<thead class="styTableThead" style="height:auto;">
								<tr>
									<th class="styTableCellHeader" scope="col" rowspan="3" style="width:46mm;font-weight:normal;">
										<strong>(a)</strong> Owner or lessee <br/> of utilization facility
									</th>
									<th class="styTableCellHeader" scope="colgroup" colspan="6" style="width:auto;border-right-width:0px;height:5mm;">
				 						<strong>Qualified Carbon Oxide Supplier</strong> 
									</th>
								</tr>
								<tr>
									<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;height:10mm;">
										<strong>(i)</strong> 
										<span style="width:60mm;margin-left:0.5mm;border-bottom:1px solid black;">
											<xsl:call-template name="FillNameChoice">
												<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/SupplierName"/>
												<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/SupplierPersonNm"/>
											</xsl:call-template>
										</span>
									</th>								
									<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;height:10mm;">
										<strong>(ii)</strong> 
										<span style="width:60mm;margin-left:0.5mm;border-bottom:1px solid black;">
											<xsl:call-template name="FillNameChoice">
												<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/SupplierName"/>
												<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/SupplierPersonNm"/>
											</xsl:call-template>
										</span>
									</th>
									<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;height:10mm;border-right-width:0px;">
										<strong>(iii)</strong> 
										<span style="width:60mm;margin-left:0.5mm;border-bottom:1px solid black;">
											<xsl:call-template name="FillNameChoice">
												<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/SupplierName"/>
												<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/SupplierPersonNm"/>
											</xsl:call-template>
										</span>
									</th>
								</tr>
								<tr>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(b)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(c)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(d)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(e)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(f)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col" style="border-right-width:0px;">
										<strong>(g)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
									</th>
								</tr>
							</thead>
							<tbody>
								<xsl:if test="not($shouldSeparateP1T3)">
									<xsl:for-each select="$FormData/OwnerLesseeUtlzFcltyLCAGrp">
										<xsl:variable name="rowNum"><xsl:number format="A" value="position()"/></xsl:variable>							
										<tr>
											<td class="styTableCellTextInherit">
												<span style="font-weight:bold;width:4mm;"><xsl:value-of select="$rowNum"/></span>
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="OwnerOrLesseeBusinessName"/>
													<xsl:with-param name="TargetPersonName" select="OwnerOrLesseePersonNm"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<span style="float:left;">
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 1 Person Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierPersonNm"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 1 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierName/BusinessNameLine1Txt"/>
													</xsl:call-template>
												</span>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<span style="float:left;">
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 2 Person Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierPersonNm"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 2 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierName/BusinessNameLine1Txt"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 2 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierName/BusinessNameLine2Txt"/>
													</xsl:call-template>
												</span>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<span style="float:left;">
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 3 Person Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierPersonNm"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 3 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierName/BusinessNameLine1Txt"/>
													</xsl:call-template>
												</span>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="border-right-width:0px;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>							
								<xsl:if test="$shouldSeparateP1T3 or count($FormData/OwnerLesseeUtlzFcltyLCAGrp) &lt; 4">
									<xsl:call-template name="FillPart1Table3">
										<xsl:with-param name="LineNumber" select="count($FormData/OwnerLesseeUtlzFcltyLCAGrp) + 1"/>
											<xsl:with-param name="MaxLine" select="4"/>
											<xsl:with-param name="SepMessage" select="$shouldSeparateP1T3"/>
									</xsl:call-template>
								</xsl:if>				
								<!--Total-->	
								<tr style="vertical-align:bottom;">
									<td class="styTableCellTextInherit">
										Total 
										<span class="sty8933SchFDotLn">.........</span>
									</td>					
									<td class="styTableCellAmtInherit" style="height:5mm;">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/TotSuprMetricTonsDlvrUtlzGrp/DeliveredQty"/>
										</xsl:call-template>
									</td>	
									<td class="styTableCellAmtInherit" style="height:5mm;">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/TotSuprMetricTonsDlvrUtlzGrp/UtilizedQty"/>
										</xsl:call-template>
									</td>
									<td class="styTableCellAmtInherit"  style="height:5mm;">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/TotSuprMetricTonsDlvrUtlzGrp/DeliveredQty"/>
										</xsl:call-template>
									</td>	
									<td class="styTableCellAmtInherit"  style="height:5mm;">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/TotSuprMetricTonsDlvrUtlzGrp/UtilizedQty"/>
										</xsl:call-template>
									</td>
									<td class="styTableCellAmtInherit"  style="height:5mm;">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/TotSuprMetricTonsDlvrUtlzGrp/DeliveredQty"/>
										</xsl:call-template>
									</td>	
									<td class="styTableCellAmtInherit"  style="height:5mm;border-right-width:0px;">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/TotSuprMetricTonsDlvrUtlzGrp/UtilizedQty"/>
										</xsl:call-template>
									</td>
								</tr>
							</tbody>		
						</table>
					</div>			
					<!-- Part I section 2 table 3 Total -->
					<div class="styTableContainerLandscape" style="width:256mm;border-bottom-width:0px;" id="Part1Table4">
						<xsl:call-template name="SetInitialState"/>
						<table class="styTable" style="font-size:7pt;border-collapse:collapse;">	
							<thead class="styTableThead" style="height:auto;">
								<tr>
									<th class="styTableCellHeader" scope="col" rowspan="2" style="background-color:lightgrey;width:8mm;border-bottom-width:0px;">&nbsp;</th>
								</tr>
								<tr>
									<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:82mm;font-weight:normal;height:10mm;">
										<strong>(iv)</strong> Total qualified carbon oxide <br/> from all suppliers
									</th>								
									<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:82mm;font-weight:normal;height:10mm;">
										<strong>(v)</strong> Total nonqualified carbon oxide <br/> from all suppliers
									</th>
									<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:82mm;font-weight:normal;height:10mm;border-right-width:0px;">
										<strong>(vi)</strong> Total metric tons <br/> for all carbon oxide suppliers
									</th>
								</tr>
								<tr>
									<th class="styTableCellHeader" scope="col" rowspan="2" style="width:5mm;background-color:lightgrey;"></th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(h)</strong> Metric tons of carbon oxide <br/> delivered to utilization facility <br/> (add columns (b), (d), and (f))
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(i)</strong> Metric tons of <br/> carbon oxide utilized <br/> (add columns (c), (e), and (g))
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(j)</strong> Metric tons of carbon oxide <br/> delivered to utilization facility
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col">
										<strong>(k)</strong> Metric tons of <br/> carbon oxide utilized
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col" >
										<strong>(l)</strong> Metric tons of carbon oxide <br/> delivered to utilization facility <br/> (add columns (h) and (j))
									</th>
									<th class="sty8933SchFtableCellHeader" scope="col" style="border-right-width:0px;">
										<strong>(m)</strong> Metric tons of <br/> carbon oxide utilized <br/> (add columns (i) and (k))
									</th>
								</tr>
							</thead>
							<tbody>
							<xsl:if test="not($shouldSeparateP1T3)">
								<xsl:for-each select="$FormData/OwnerLesseeUtlzFcltyLCAGrp">
									<xsl:variable name="rowNum"><xsl:number format="A" value="position()"/></xsl:variable>
									<tr>
										<td class="styTableCellTextInherit">
											<span style="font-weight:bold;width:4mm;"><xsl:value-of select="$rowNum"/></span>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="TotQlfyCrbnOxdDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="TotQlfyCrbnOxdDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="TotNonQlfyOxdDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="TotNonQlfyOxdDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="TotAllCrbnOxdSuprDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="border-right-width:0px;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="TotAllCrbnOxdSuprDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="$shouldSeparateP1T3 or count($FormData/OwnerLesseeUtlzFcltyLCAGrp) &lt; 4">
								<xsl:call-template name="FillPart1Table3Tot">
									<xsl:with-param name="LineNumber" select="1 + count($FormData/OwnerLesseeUtlzFcltyLCAGrp)"/>
									<xsl:with-param name="MaxLine" select="4"/>
									<xsl:with-param name="SepMessage" select="$shouldSeparateP1T3"/>
								</xsl:call-template>
							</xsl:if>
							<!--Total-->
							<tr style="vertical-align:bottom;">					
								<td class="styTableCellCtrInherit">
									Total
								</td>
								<td class="styTableCellAmtInherit" style="height:5mm;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/AllTotQlfyCrbnOxdDlvrUtlzGrp/DeliveredQty"/>
									</xsl:call-template>
								</td>	
								<td class="styTableCellAmtInherit" style="height:5mm;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/AllTotQlfyCrbnOxdDlvrUtlzGrp/UtilizedQty"/>
									</xsl:call-template>
								</td>
								<td class="styTableCellAmtInherit" style="height:5mm;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/AllTotNonQlfyOxdDlvrUtlzGrp/DeliveredQty"/>
									</xsl:call-template>
								</td>	
								<td class="styTableCellAmtInherit" style="height:5mm;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/AllTotNonQlfyOxdDlvrUtlzGrp/UtilizedQty"/>
									</xsl:call-template>
								</td>
								<td class="styTableCellAmtInherit" style="height:5mm;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/AllTotCrbnOxdDlvrUtlzSuprGrp/DeliveredQty"/>
									</xsl:call-template>
								</td>	
								<td class="styTableCellAmtInherit" style="height:5mm;border-right-width:0px;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/AllTotCrbnOxdDlvrUtlzSuprGrp/UtilizedQty"/>
									</xsl:call-template>
								</td>
							</tr>
						</tbody>		
					</table>
				</div>	
				<xsl:variable name="ExcessSuppliers" select="$FormData/OwnerLesseeUtlzFcltyLCAGrp/SupplierSectionDlvrUtlzGrp[count(preceding-sibling::*) mod 3 = 1 and position() > 1]"/>
				<xsl:for-each select="$ExcessSuppliers">
						<xsl:variable name="pos" select="count(preceding-sibling::*)"/>
						<xsl:if test="position() != 1">
							<br /><br />
						</xsl:if>
						<div class="styTableContainerLandscape" style="" id="Part1TableX">
							<xsl:call-template name="SetInitialState"/>
							<table class="styTable" style="font-size:7pt;border-collapse:collapse;">
								<thead class="styTableThead">
									<tr style="border-top:1px solid black;">
										<th class="styTableCellHeader" scope="col" rowspan="3" style="width:46mm;font-weight:normal;">
											<strong>(a)</strong>Owner or lessee <br/> of utilization facility
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="6" style="width:auto;border-right-width:0px;">
											Qualified Carbon Oxide Supplier
										</th>
									</tr>
									<tr>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;padding-top:1.5mm;padding-bottom:1.5mm;">
											<strong>(<xsl:number value="$pos" format="i"/>)</strong> 
											<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="SupplierName"/>
													<xsl:with-param name="TargetPersonName" select="SupplierPersonNm"/>
												</xsl:call-template>
											</span>
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;">
											<strong>(<xsl:number value="$pos + 1" format="i"/>)</strong> 
											<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="../SupplierSectionDlvrUtlzGrp[$pos + 1]/SupplierName"/>
													<xsl:with-param name="TargetPersonName" select="../SupplierSectionDlvrUtlzGrp[$pos + 1]/SupplierPersonNm"/>
												</xsl:call-template>
											</span>
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;border-right-width:0px;">
											<strong>(<xsl:number value="$pos + 2" format="i"/>)</strong> 
											<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="../SupplierSectionDlvrUtlzGrp[$pos + 2]/SupplierName"/>
													<xsl:with-param name="TargetPersonName" select="../SupplierSectionDlvrUtlzGrp[$pos + 2]/SupplierPersonNm"/>
												</xsl:call-template>
											</span>
										</th>
									</tr>
									<tr>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(b)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(c)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(d)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(e)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(f)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;border-right-width:0px;">
											<strong>(g)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
										</th>
									</tr>
								</thead>
								<tbody>
									<xsl:variable name="rowNum" select="count(../preceding-sibling::OwnerLesseeUtlzFcltyLCAGrp) + 1"></xsl:variable>
									<xsl:variable name="rowLetter"><xsl:number format="A" value="$rowNum"/></xsl:variable>
									<tr style="vertical-align:bottom;">
										<td class="styTableCellTextInherit">
											<span style="font-weight:bold;width:4mm;"><xsl:value-of select="$rowLetter"/></span>
											<xsl:call-template name="FillNameChoice">
												<xsl:with-param name="TargetBusinessName" select="../OwnerOrLesseeBusinessName"/>
												<xsl:with-param name="TargetPersonName" select="../OwnerOrLesseePersonNm"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="../SupplierSectionDlvrUtlzGrp[$pos]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="../SupplierSectionDlvrUtlzGrp[$pos]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="../SupplierSectionDlvrUtlzGrp[$pos + 1]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="../SupplierSectionDlvrUtlzGrp[$pos + 1]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="../SupplierSectionDlvrUtlzGrp[$pos + 2]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="border-right-width:0px;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="../SupplierSectionDlvrUtlzGrp[$pos + 2]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="$FormData/TotSupplierSectionDlvrUtlzGrp[position() &gt; 3]">
						<xsl:if test="position() mod 3 = 1">
							<xsl:variable name="pos" select="position() + 3"/>
							<br /><br />
							<div class="styTableContainerLandscapeNBB" style="" id="Part1TableTotalGroupX">
								<xsl:call-template name="SetInitialState"/>
								<table class="styTable" style="font-size:7pt;border-collapse:collapse;">
									<thead class="styTableThead">
										<tr style="border-top:1px solid black;">
											<th class="styTableCellHeader" scope="col" rowspan="3" style="width:28mm;font-weight:normal;">
												&nbsp;
											</th>
											<th class="styTableCellHeader" scope="colgroup" colspan="6" style="width:auto;border-right-width:0px;">
												Qualified Carbon Oxide Supplier
											</th>
										</tr>
										<tr>
											<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:76mm;font-weight:normal;padding-top:1.5mm;padding-bottom:1.5mm;">
												<strong>(<xsl:number value="$pos" format="i"/>)</strong> 
												<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
													<xsl:call-template name="FillNameChoice">
														<xsl:with-param name="TargetBusinessName" select="SupplierName"/>
														<xsl:with-param name="TargetPersonName" select="SupplierPersonNm"/>
													</xsl:call-template>
												</span>
											</th>
											<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:76mm;font-weight:normal;">
												<strong>(<xsl:number value="$pos + 1" format="i"/>)</strong> 
												<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
													<xsl:call-template name="FillNameChoice">
														<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 1]/SupplierName"/>
														<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 1]/SupplierPersonNm"/>
													</xsl:call-template>
												</span>
											</th>
											<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:76mm;font-weight:normal;border-right-width:0px;">
												<strong>(<xsl:number value="$pos + 2" format="i"/>)</strong> 
												<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
													<xsl:call-template name="FillNameChoice">
														<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 2]/SupplierName"/>
														<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 2]/SupplierPersonNm"/>
													</xsl:call-template>
												</span>
											</th>
										</tr>
										<tr>
											<th class="styTableCellHeader" scope="col" style="width:38mm;font-weight:normal;padding:0.5mm;">
												<strong>(b)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility 
											</th>
											<th class="styTableCellHeader" scope="col" style="width:38mm;font-weight:normal;padding:0.5mm;">
												<strong>(c)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
											</th>
											<th class="styTableCellHeader" scope="col" style="width:38mm;font-weight:normal;padding:0.5mm;">
												<strong>(d)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
											</th>
											<th class="styTableCellHeader" scope="col" style="width:38mm;font-weight:normal;padding:0.5mm;">
												<strong>(e)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
											</th>
											<th class="styTableCellHeader" scope="col" style="width:38mm;font-weight:normal;padding:0.5mm;">
												<strong>(f)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility 
											</th>
											<th class="styTableCellHeader" scope="col" style="width:38mm;font-weight:normal;padding:0.5mm;border-right-width:0px;">
												<strong>(g)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
											</th>
										</tr>
									</thead>
									<tbody>
										<tr style="vertical-align:bottom;">
											<td class="styTableCellTextInherit" style="font-weight:bold;">
												Total
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos]/TotSuprMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos]/TotSuprMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 1]/TotSuprMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 1]/TotSuprMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 2]/TotSuprMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="border-right-width:0px;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[$pos + 2]/TotSuprMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</xsl:if>
					</xsl:for-each>	
					<!-- Part I Line 9 -->
					<div class="styStdDivLS">
						<div class="styLNLeftNumBoxSD">9</div>
						<div style="width:250;padding-top:.5mm;">
							Check here to attest that all information provided on line 8 conforms to the LCA that was subject to a technical review by the DOE, and approved by the IRS
						<span class="sty8933SchFDotLn" style="padding-left:.2mm;">............</span>
						</div>	
						<span style="float:right;padding-right:1mm;padding-top:.5mm;">					
							<input type="Checkbox" class="styCkboxNM" alt="Attestation Ind" aria-label="Attestation">
								<xsl:call-template name="PopulateCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/AttestationInd"/>
									<xsl:with-param name="BackupName">Form8933SchFAttestationInd</xsl:with-param>
								</xsl:call-template>
							</input>
						</span>	
					</div>
					<!-- Part I Line 10 -->
					<div class="styStdDivLS">		
						<div class="styLNLeftNumBox">10</div>	
						<div style="width:220;padding-top:.5mm;">
							Attach a copy of the LCA approval letter from the IRS. Don't file this certificate if you haven't received the approval letter.
						</div>	
						<xsl:call-template name="SetFormLinkInline">
							<xsl:with-param name="TargetNode" select="$FormData/AttestationInd"/>
						</xsl:call-template>
					</div>
					<!-- Part I Line 11 -->	
					<div class="styStdDivLS" style="border-bottom:1px solid black;">		
						<div class="styLNLeftNumBox">11</div>	
						<div style="width:220;padding-top:.5mm;">
							If the total for column (h) is less than 25,000 metric tons, have you verified with the supplier that its facility meets the minimum capture requirements?
						</div>	
						<span style="width:37mm;"></span>
						<input type="Checkbox" class="styCkboxNM" alt="Supplier verification indicator Yes"  aria-label="Supplier verification Yes">
							<xsl:call-template name="PopulateYesCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/SupplierVerificationInd"/>
								<xsl:with-param name="BackupName">Form8933SchFSupplierVerificationInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:1mm;"/>	
						<strong>Yes</strong>
						<span style="width:3mm;"/>								
						<input type="Checkbox" class="styCkboxNM" alt="Supplier verification indicator No" aria-label="Supplier verification No">
							<xsl:call-template name="PopulateNoCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/SupplierVerificationInd"/>
								<xsl:with-param name="BackupName">Form8933SchFSupplierVerificationInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:1mm;"/>
						<strong>No</strong>
					</div>
					<!-- Page 2 FOOTER-->
					<div style="width:256mm;">
						<div style="float:right">
							<b>Schedule F (Form 8933) (12-2024)</b>
						</div>
					</div>
					<div class="pageEnd"/>
					<!-- Page 3 HEADER-->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div style="float: left; clear: none">Schedule F (Form 8933) (12-2024) </div>						
						<div style="float:right">
							Page <span class="styBoldText" style="font-size: 8pt">3</span>
						</div>
					</div>
					<!-- Part II -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styPartName">Part II</div>
						<div class="styPartDesc">
							Information About the LCA and This Claim 
						</div>
					</div>
					<!-- Part II Line 1 -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="sty8933SchFDesc">
							Title of the LCA submitted to the DOE <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/TitleTxt"/>
							</xsl:call-template>
						</div>
						<!-- Part II Line 2 -->
						<div class="styLNLeftNumBoxSD">2</div>
						<div style="float:right;width:90mm;padding-top:.5mm;">
							Date (MM/DD/YYYY) the LCA was submitted to the DOE <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/SubmissionDt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part II Line 3 -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styLNLeftNumBoxSD">3</div>
						<div class="sty8933SchFDesc" style="width:110mm;">
							Project or LCA number assigned by the DOE <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/DOEControlNum"/>
							</xsl:call-template>
						</div>
						<!-- Part II Line 4 -->
						<div class="styLNLeftNumBoxSD">4</div>
						<div style="width:120mm;padding-top:.5mm;">
							Date (MM/DD/YYYY) approval letter for the utilization facility was received from the IRS 
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/ApprovalLetterDt"/>
							</xsl:call-template><br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/ApprovalLetterDt"/>
							</xsl:call-template>						
						</div>
					</div>
					<!-- Part II Line 5 -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styLNLeftNumBoxSD">5</div>
						<div class="styLNDescLandscape" style="width:116mm;">
							Attach a copy of the approval letter from the IRS.
						</div>
					</div>
					<!-- Part II Line 6 -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="styLNDescLandscape" style="height:9mm;">
							State if you're applying the Treasury Decision 9944 (TD) or the June 2020 Notice of Proposed Rulemaking (NPRM) <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/TD9944OrNPRMCd"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part III -->
					<div class="styStdDivLS" style="border-bottom:1px solid black;">
						<div class="styPartName">Part III</div>
						<div class="styPartDesc">
							Information About You and Each of Your Suppliers of Qualified Carbon Oxide 
						</div>
					</div>
					<!-- Part III Section 1 -->
					<div class="styStdDivLS">
						<div class="styLNDescLandscape" style="font-weight:bold;">
							Section 1&mdash;Information about you, the owner or lessee of the utilization project
						</div>
					</div>
					<!-- Part III Line 1 -->
					<div class="styBB" style="width:256mm;border-top:1px solid black;">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="styNameBox" style="width:170mm;font-size:7pt;padding-top:.5mm;height:9mm;">
							Name <br/>
							<xsl:choose>
								<xsl:when test="$FormData/OwnerOrLesseePersonNm">											
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseePersonNm"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>	
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseeBusinessName/BusinessNameLine1Txt"/>
									</xsl:call-template>
									<br/>
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseeBusinessName/BusinessNameLine2Txt"/>
									</xsl:call-template>													
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<!-- Part III Line 3 -->
						<div>
							<div class="styLNLeftNumBoxSD">3</div>
							<div class="styEINBox" style="width:66mm;padding-left:0.5mm;font-weight:normal;padding-top:1px;font-size:7pt;height:9mm;">
								EIN	<br/>
								<xsl:choose>
									<xsl:when test="$FormData/OwnerOrLesseeSSN">																	
										<xsl:call-template name="PopulateSSN">
											<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseeSSN"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="PopulateEIN">									
											<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseeEIN"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</div>
						</div>
					</div>
					<!-- Part III Line 2 -->
					<div class="styBB" style="width:256mm;">			
						<div class="styLNLeftNumBoxSD">2</div>
						<div class="styLNDescLandscape" style="width:246;height:auto;">
							Address <br/>
							<xsl:choose>
								<xsl:when test="$FormData/OwnerOrLesseeUSAddress">
									<xsl:call-template name="PopulateUSAddressTemplate">
										<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseeUSAddress" />
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="PopulateForeignAddressTemplate">
										<xsl:with-param name="TargetNode" select="$FormData/OwnerOrLesseeForeignAddress" />
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>									
						</div>
					</div>
					<!-- Part III Section 2 -->
					<div class="styBB" style="width:256mm;border-bottom-width:0px;">
						<div class="styLNDescLandscape" style="width:256mm;font-weight:bold;">
							Section 2&mdash;Information about all suppliers of qualified carbon oxide to you. Complete multiple certificates if you had more than one supplier of qualified carbon oxide
						</div>
					</div>
					<!-- Part III Section 2 Line 4 -->	
					<div class="styBB" style="width:256mm;border-top:1px solid black;">
						<div class="styLNLeftNumBoxSD">4</div>
						<div class="styNameBox" style="width:170mm;font-size:7pt;padding-top:.5mm;height:auto;">
							Supplier's Name <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/SupplierName"/>
							</xsl:call-template>
						</div>
						<!-- Part III Section 2 Line 5 -->
						<div class="styLNLeftNumBoxSD">5</div>
						<div class="styEINBox" style="width:66mm;padding-left:0.5mm;font-weight:normal;font-size:7pt;padding-top:.5mm;">
							Supplier's EIN <br/>
							<xsl:call-template name="PopulateEIN">									
								<xsl:with-param name="TargetNode" select="$FormData/SupplierEIN"/>
							</xsl:call-template>
						</div>
					</div>	
					<!-- Part III Section 2 Line 6 -->
					<div class="styBB" style="width:256mm;border-bottom-width:1px;">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="sty8933SchFDesc" style="width:110mm;height:auto;">
							Name and location of carbon oxide capture facility (if supplier supplied any <br />
							qualified carbon oxide) <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityNameAndLocationTxt"/>
							</xsl:call-template>
						</div>
						<!-- Part III Section 2 Line 7 -->
						<div class="styLNLeftNumBoxSD">7</div>
						<div style="width:120mm;padding-top:.5mm;">
							Type of industrial facility at which the supplier captured its qualified carbon oxide <br/>
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityTypeDesc"/>
							</xsl:call-template>
						</div>
					</div>
					<div class="styBB" style="width:256mm;border-bottom-width:1px;">
					<!-- Part III Section 2 Line 8 -->
					<div class="styBB" style="width:256mm;border-bottom-width:0px;border-top-width:0px;">
						<div class="styLNLeftNumBoxSD">8</div>
						<div style="width:245mm;padding-top:.5mm;">Check here if you were one of the suppliers. Don't check unless the EIN of the supplier of the qualified carbon 
							oxide is the same as your EIN. If the EINs aren't the<br/>
							same, there must be a binding written contract between the entities<span class="sty8933SchFDotLn">.......................................</span>		
						</div>					
						<input type="Checkbox" class="styCkboxNM" alt="Supplier indicator" aria-label="Supplier">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/SupplierInd"/>
								<xsl:with-param name="BackupName">Form8933SchFSupplierInd</xsl:with-param>
							</xsl:call-template>
						</input>									
					</div>				
					<!-- Part III Section 2 Line 9 -->
					<div class="styBB" style="width:256mm;border-bottom-width:0px;border-top-width:0px;padding-top:4mm;">
						<div class="styLNLeftNumBoxSD">9</div>
						<div style="width:225mm;padding-top:.5mm;"> Unless line 8 is checked, do you attest that a binding written contract between you and the supplier exists that 
							ensures that you will utilize its qualified <br/>
							carbon oxide in the manner required under section 45Q(f)(5) and the underlying regulations? <span class="sty8933SchFDotLn">..........................</span>
						</div>							
						<input type="Checkbox" class="styCkboxNM" alt="Contract exists indicator Yes" aria-label="Contract exists Yes">
							<xsl:call-template name="PopulateYesCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/ContractExistsInd"/>
								<xsl:with-param name="BackupName">Form8933SchFContractExistsInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:1mm;"/>	
						<strong>Yes</strong>
						<span style="width:3mm;"/>								
						<input type="Checkbox" class="styCkboxNM" alt="Contract exists indicator No" aria-label="Contract exists No">
							<xsl:call-template name="PopulateNoCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/ContractExistsInd"/>
								<xsl:with-param name="BackupName">Form8933SchFContractExistsInd</xsl:with-param>
							</xsl:call-template>
						</input>
						<span style="width:1mm;"/>
						<strong>No</strong>						
					</div>
					<!-- Part III Section 2 Line 10 -->
					<div class="styBB" style="width:256mm;border-bottom-width:0px;border-top-width:0px;padding-top:4mm;">
						<div class="styLNLeftNumBox">10</div>
						<div style="width:225mm;padding-top:.5mm;">Provide the date (MM/DD/YYYY) of the contract referenced on line 9 or the date of the most recent contract amendment
							<span class="sty8933SchFDotLn">..................</span>
						</div>	
						<span style="border-color:black;border-style:solid;border-right-width:0px;float:right;
							border-left-width:0px;border-top-width:0px;border-bottom-width:1px;width:22mm"> 
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/ContractOrAmendmentDt"/>
							</xsl:call-template>
						</span>
					</div>
					<!-- Part III Section 2 Line 11 -->
					<div class="styStdDivLS" style="width:256mm;border-bottom-width:0px;border-top-width:0px;padding-top:4mm;">
						<div class="styLNLeftNumBox" style="height:8mm;">11</div>
						<div class="styLNDescLandscape" style="width:200mm;height:8mm;">
							Metric tons of qualified carbon oxide received from the supplier during the year and used in the process indicated on line 6 (metric tons <br />
							should agree with the figure reported on Part I, line 8)<span class="sty8933SchFDotLn">.................................</span>
						</div>					
						<div class="styLNRightNumBox" style="height:8mm;padding-top:4mm;">
							11</div>
						<div class="sty8933SchFLNAmountBox" style="height:8mm;padding-top:5mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/MtrcTonsQlfyCrbnOxdRcvdQty"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part III Section 2 Line 12 -->
					<div class="styStdDivLS" style="width:256mm;border-bottom-width:0px;border-top-width:0px;">
						<div class="styLNLeftNumBox" style="height:12mm;padding-top:4mm;">12</div>
						<div class="styLNDescLandscape" style="width:200mm;height:12mm;padding-top:4mm;">
							Metric tons of the supplier's qualified carbon oxide, expressed as carbon dioxide equivalent, utilized in your facility and determined by an <br />
							LCA (metric tons should agree with the figure reported on Part I, line 8)<span class="sty8933SchFDotLn">...........................</span>
						</div>					
						<div class="styLNRightNumBox" style="height:12mm;padding-top:8mm;">
							12</div>
						<div class="sty8933SchFLNAmountBox">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdMtrcTonsUtlzQty"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part III Section 2 Line 13 -->
					<div class="styStdDivLS" style="width:256mm;border-bottom-width:0px;border-top-width:0px;">
						<div class="styLNLeftNumBox" style="height:12mm;padding-top:4mm;">13</div>
						<div class="styLNDescLandscape" style="width:200mm;height:12mm;padding-top:4mm;">
							Metric tons of the supplier's nonqualified carbon oxide, expressed as carbon dioxide equivalent, utilized in your facility and determined by an <br />
							LCA (metric tons should be part of the figure on Part I, line 8)<span class="sty8933SchFDotLn">..............................</span>
						</div>					
						<div class="styLNRightNumBox" style="height:12mm;padding-top:8mm;">
							13</div>
						<div class="sty8933SchFLNAmountBox">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/NonQlfyCrbnOxdMtrcTonsUtlzQty"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part III Section 2 Line 14 -->
					<div class="styStdDivLS" style="width:256mm;border-bottom-width:0px;border-top-width:0px;">
						<div class="styLNLeftNumBox" style="height:12mm;padding-top:4mm;">14</div>
						<div class="styLNDescLandscape" style="width:245mm;height:12mm;padding-top:4mm;">
							Check here if you attest that the supplier of qualified carbon oxide elected to allow 
							you to claim some or all of the carbon oxide sequestration credit attributable to their
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData/TPElectClmCrbnOxdSqstrtnCrInd"/>
							</xsl:call-template>
							<br/>
							qualified carbon oxide. Attach Schedule E (Form 8933)<span class="sty8933SchFDotLn">...........................................</span>
						</div>	
						<div style="float:right;height:12mm;padding-top:7mm;">						
						<input type="Checkbox" class="styCkboxNM" alt="TPElectClmCrbnOxdSqstrtnCrInd" aria-label="TPElectClmCrbnOxdSqstrtnCrInd">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/TPElectClmCrbnOxdSqstrtnCrInd"/>
								<xsl:with-param name="BackupName">Form8933SchFTPElectClmCrbnOxdSqstrtnCrInd</xsl:with-param>
							</xsl:call-template>
						</input></div>				
					</div>
					</div>
					<!-- Page 3 FOOTER-->
					<div style="width:256mm;">
						<div style="float:right">
							<b>Schedule F (Form 8933) (12-2024)</b>
						</div>
					</div>
					<div class="pageEnd"/>
					<!-- Additonal Data Title Bar and Button -->
					<div class="styLeftOverTitleLineLandscape" id="LeftoverData">
						<div class="styLeftOverTitle">
						   Additional Data        
						</div>
						<div class="styLeftOverButtonContainerLandscape">
							<input class="styLeftoverTableBtn" type="button" TabIndex="-1" value="Return to Form" onclick="javascript:returnToWriteInImage();"/>
						</div>
					</div>
					<!-- Additional Data Table -->
					<table class="styLeftOverTblLandscape">
						<xsl:call-template name="PopulateCommonLeftover">
							<xsl:with-param name="TargetNode" select="$FormData"/>
							<xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
						<xsl:for-each select="$FormData/OwnerLesseeUtlzFcltyLCAGrp">
							<xsl:variable name="RowLetter"><xsl:number value="position()" format="A"/></xsl:variable>
							<xsl:for-each select="SupplierSectionDlvrUtlzGrp[position() &lt;= 3]">
								<xsl:variable name="ColLetter"><xsl:number value="position()" format="i"/></xsl:variable>
								<tr>
									<td class="styLeftOverTableRowDesc" style="width:100mm;" scope="row">
										Part I, Line 8, Row <xsl:value-of select="$RowLetter"/>, 
										col(<xsl:value-of select="$ColLetter"/>) - Supplier Name:
									</td>
									<td class="styLeftOverTableRowAmount" style="width:150mm;">
										<xsl:call-template name="FillNameChoice">
											<xsl:with-param name="TargetBusinessName" select="SupplierName"/>
											<xsl:with-param name="TargetPersonName" select="SupplierPersonNm"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:for-each>
					</table>
					<xsl:if test="$shouldSeparateP1T1">
					<br/>
					<br/>
					<span class="styRepeatingDataTitle"/>
					<table class="styTable" style="font-size:7pt;border-collapse:collapse;">
						<thead class="styTableThead" style="height:12mm;">
							<tr class="styDepTblHdr">
								<th class="styTableCellHeader" scope="col" style="width:5mm;font-weight:normal;border-right-width:0px;">&nbsp;</th>
								<th class="styTableCellHeader" scope="col" style="width:60mm;font-weight:normal;vertical-align:top;padding-top:5px;">
									<strong>(i)</strong> Name
								</th>
								<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;vertical-align:top;padding-top:5px;">
									<strong>(ii)</strong> Owner/ <br /> Lessee
								</th>
								<th class="styTableCellHeader" scope="col" style="width:116mm;font-weight:normal;vertical-align:top;padding-top:5px;">
									<strong>(iii)</strong> Address
								</th>
								<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;vertical-align:top;padding-top:5px;">
									<strong>(iv)</strong> Employer<br /> identification <br /> number (EIN)
								</th>
								<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;border-right-width:0px;vertical-align:top;padding-top:5px;">
									<strong>(v)</strong> Operating <br /> interest (%)
								</th>
							</tr>
						</thead>						
						<tbody>
							<xsl:for-each select="$FormData/OwnerOrLesseeCrbnUtlzFcltyGrp">
								<tr>
									<td class="styTableCellCtrInherit" style="font-weight:bold;border-right-width:0px;">
										<xsl:number format="A" value="position()"/>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:choose>
											<xsl:when test="FacilityOwnerPersonNm">											
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="FacilityOwnerPersonNm"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>	
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="FacilityOwnerBusinessName/BusinessNameLine1Txt"/>
												</xsl:call-template>
												<xsl:if test="FacilityOwnerBusinessName/BusinessNameLine2Txt">
													<br/>
													<xsl:call-template name="PopulateText">
														<xsl:with-param name="TargetNode" select="FacilityOwnerBusinessName/BusinessNameLine2Txt"/>
													</xsl:call-template>
												</xsl:if>													
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="OwnerOrLesseeCd" />
										</xsl:call-template>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:choose>
											<xsl:when test="FacilityOwnerUSAddress">
												<xsl:call-template name="PopulateUSAddressTemplate">
													<xsl:with-param name="TargetNode" select="FacilityOwnerUSAddress" />
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="PopulateForeignAddressTemplate">
													<xsl:with-param name="TargetNode" select="FacilityOwnerForeignAddress" />
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>										
									</td>
									<td class="styTableCellTextInherit">
										<xsl:choose>
											<xsl:when test="FacilityOwnerSSN">										
												<xsl:call-template name="PopulateSSN">
													<xsl:with-param name="TargetNode" select="FacilityOwnerSSN"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="PopulateEIN">									
													<xsl:with-param name="TargetNode" select="FacilityOwnerEIN"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="styTableCellAmtInherit" style="border-right-width:0px;">
										<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="OperatingInterestPct" />
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>			
				<xsl:if test="$shouldSeparateP1T2">
					<br/>
					<br/>
					<span class="styRepeatingDataTitle"/>
					<table class="styTable" style="font-size:7pt;border-collapse:collapse;">	
						<thead class="styTableThead" style="height:15mm;">
							<tr class="styDepTblHdr">
								<th class="styTableCellHeader" scope="col" style="width:5mm;font-weight:normal;border-right-width:0px;">&nbsp;</th>
								<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;vertical-align:top;padding-top:10px;">
									<strong>(i)</strong> Qualified carbon <br/> oxide supplier
								</th>
								<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;vertical-align:top;padding-top:10px;">
									<strong>(ii)</strong> EIN
								</th>
								<th class="styTableCellHeader" scope="col" style="width:50mm;font-weight:normal;vertical-align:top;padding-top:10px;">
									<strong>(iii)</strong> Name of <br/> capture facility
								</th>
								<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;vertical-align:top;padding-top:10px;">
									<strong>(iv)</strong> Location of<br /> capture facility <br /> (county and state)
								</th>
								<th class="styTableCellHeader" scope="col" style="width:50mm;font-weight:normal;vertical-align:top;padding-top:10px;">
									<strong>(v)</strong> IRS-issued registration <br /> number
								</th>
								<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;vertical-align:top;padding-top:10px;">
									<strong>(vi)</strong> EPA <br /> e-GGRT <br /> ID number(s)
								</th>
								<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;border-right-width:0px;vertical-align:top;padding-top:10px;">
									<strong>(vii)</strong> Check if <br /> supplier <br /> supplied any <br /> nonqualified <br /> carbon oxide
								</th>
							</tr>
						</thead>						
						<tbody>
							<xsl:for-each select="$FormData/QlfyCrbnOxdUtlzFcltyGrp">
								<tr>
									<td class="styTableCellCtrInherit" style="vertical-align:middle;font-weight:bold;border-right-width:0px;">
										<xsl:number format="A" value="position()"/>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="SupplierName/BusinessNameLine1Txt"/>
										</xsl:call-template>
										<br/>
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="SupplierName/BusinessNameLine2Txt"/>
										</xsl:call-template>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateEIN">
											<xsl:with-param name="TargetNode" select="SupplierEIN" />
										</xsl:call-template>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="FacilityName/BusinessNameLine1Txt"/>
										</xsl:call-template>
										<br/>
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="FacilityName/BusinessNameLine2Txt"/>
										</xsl:call-template>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="LocationTxt" />
										</xsl:call-template>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="FacilityIRSIssdRegistrationNum" />
										</xsl:call-template>
									</td>
									<td class="styTableCellTextInherit">
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="FacilityEPAeGGRTIdNum" />
										</xsl:call-template>
									</td>
									<td class="styTableCellCtrInherit" style="border-right-width:0px;">										
										<input class="styCkbox" type="checkbox" alt="Non qualified carbon oxide supplier indicator">
												<xsl:attribute name="aria-label">
													Row <xsl:number format="A" value="position()"/>, Non qualified carbon oxide supplier
												</xsl:attribute>
											<xsl:call-template name="PopulateCheckbox">
												<xsl:with-param name="TargetNode" select="NonQlfyCrbnOxdSupplierInd"/>
												<xsl:with-param name="BackupName">Form8933SchFNonQlfyCrbnOxdSupplierInd<xsl:value-of select="position()"/></xsl:with-param>
											</xsl:call-template>
										</input>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>								
				
				<xsl:if test="$shouldSeparateP1T3">
						<div class="styTableContainerLandscape" style="" id="Part1Table3">
							<xsl:call-template name="SetInitialState"/>
							<table class="styTable" style="font-size:7pt;border-collapse:collapse;">
								<thead class="styTableThead">
									<tr class="styDepTblHdr" style="border-top:1px solid black;">
										<th class="styTableCellHeader" scope="col" rowspan="3" style="width:46mm;font-weight:normal;">
											<strong>(a)</strong>Owner or lessee <br/> of utilization facility
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="6" style="width:auto;border-right-width:0px;">
											Qualified Carbon Oxide Supplier
										</th>
									</tr>
									<tr>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;padding-top:1.5mm;padding-bottom:1.5mm;font-weight:normal;">
											<strong>(i)</strong> 
											<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/SupplierName"/>
													<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/SupplierPersonNm"/>
												</xsl:call-template>
											</span>
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;font-weight:normal;">
											<strong>(ii)</strong> 
											<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/SupplierName"/>
													<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/SupplierPersonNm"/>
												</xsl:call-template>
											</span>
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:70mm;border-right-width:0px;font-weight:normal;">
											<strong>(iii)</strong> 
											<span style="width:60mm;border-bottom:1px solid black;margin-left:0.5mm;">
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/SupplierName"/>
													<xsl:with-param name="TargetPersonName" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/SupplierPersonNm"/>
												</xsl:call-template>
											</span>
										</th>
									</tr>
									<tr>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(b)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(c)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(d)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(e)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;">
											<strong>(f)</strong> Metric tons of <br/> qualified carbon oxide <br/> delivered to <br/> utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:35mm;font-weight:normal;padding:0.5mm;border-right-width:0px;">
											<strong>(g)</strong> Metric tons of <br/> qualified carbon oxide <br/> utilized
										</th>
									</tr>
								</thead>
								<tbody>
									<xsl:for-each select="$FormData/OwnerLesseeUtlzFcltyLCAGrp">
										<xsl:variable name="rowNum"><xsl:number format="A" value="position()"/></xsl:variable>
										<tr style="vertical-align:bottom;">
											<td class="styTableCellTextInherit">
												<span style="font-weight:bold;width:4mm;"><xsl:value-of select="$rowNum"/></span>
												<xsl:call-template name="FillNameChoice">
													<xsl:with-param name="TargetBusinessName" select="OwnerOrLesseeBusinessName"/>
													<xsl:with-param name="TargetPersonName" select="OwnerOrLesseePersonNm"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<span style="float:left;">
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 1 Person Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierPersonNm"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 1 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierName/BusinessNameLine1Txt"/>
													</xsl:call-template>
												</span>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[1]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<span style="float:left;">
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 2 Person Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierPersonNm"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 2 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierName/BusinessNameLine1Txt"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 2 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierName/BusinessNameLine2Txt"/>
													</xsl:call-template>
												</span>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[2]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<span style="float:left;">
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 3 Person Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierPersonNm"/>
													</xsl:call-template>
													<xsl:call-template name="LinkToLeftoverDataTableInline">
														<xsl:with-param name="Desc">Line 8, row <xsl:value-of select="$rowNum"/> - Supplier 3 Business Name</xsl:with-param>
														<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierName/BusinessNameLine1Txt"/>
													</xsl:call-template>
												</span>
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="border-right-width:0px;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="SupplierSectionDlvrUtlzGrp[3]/SupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
									<tr style="vertical-align:bottom;">
										<td class="styTableCellTextInherit">
											Total 
											<span class="sty8933SchFDotLn">........</span>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/TotSupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[1]/TotSupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/TotSupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[2]/TotSupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/TotSupplierMetricTonsDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="border-right-width:0px;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/TotSupplierSectionDlvrUtlzGrp[3]/TotSupplierMetricTonsDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
						<!-- Table 3 Total -->
						<div class="styTableContainerLandscapeNBB" style="" id="Part1Table4Sep">
							<xsl:call-template name="SetInitialState"/>
							<table class="styTable" style="font-size:7pt;border-collapse:collapse;">
								<thead class="styDepTblHdr">
									<tr>
										<th class="styTableCellHeader" scope="col" rowspan="2" style="width:11mm;font-weight:normal;background-color:lightgrey;">
											&nbsp;
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:81mm;padding-top:1.5mm;padding-bottom:1.5mm;font-weight:normal;">
											<strong>(iv)</strong> Total qualified carbon oxide <br /> from all suppliers
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:80mm;font-weight:normal;">
											<strong>(v)</strong> Total nonqualified carbon oxide <br /> nonqualified carbon oxide
										</th>
										<th class="styTableCellHeader" scope="colgroup" colspan="2" style="width:80mm;font-weight:normal;border-right-width:0px;">
											<strong>(vi)</strong> Total metric tons <br /> for all carbon oxide suppliers
										</th>
									</tr>
									<tr>
										<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;padding:0.5mm;">
											<strong>(h)</strong> Metric tons of carbon oxide <br /> delivered to utilization faclility <br/> (add columns (b), (d), and (f))
										</th>
										<th class="styTableCellHeader" scope="col" style="width:41mm;font-weight:normal;padding:0.5mm;">
											<strong>(i)</strong> Metric tons of <br /> carbon oxide utilized <br/> (add columns (c), (e), and (g))
										</th>
										<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;padding:0.5mm;">
											<strong>(j)</strong> Metric tons ofcarbon oxide <br/> delivered to utilization facility
										</th>
										<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;padding:0.5mm;">
											<strong>(k)</strong> Metric tons of <br/> carbon oxide utilized
										</th>
										<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;padding:0.5mm;">
											<strong>(l)</strong> Metric tons of carbon oxide <br /> delivered to utilization faclility <br/> (add columns (h) and (j))
										</th>
										<th class="styTableCellHeader" scope="col" style="width:40mm;font-weight:normal;padding:0.5mm;border-right-width:0px;">
											<strong>(m)</strong> Metric tons of <br /> carbon oxide utilized <br/> <br /> (add columns (i) and (k))
										</th>
									</tr>
								</thead>
								<tbody>
									<xsl:for-each select="$FormData/OwnerLesseeUtlzFcltyLCAGrp">
										<xsl:variable name="rowNum"><xsl:number format="A" value="position()"/></xsl:variable>
										<tr style="">
											<td class="styTableCellTextInherit">
												<span style="font-weight:bold;width:4mm;"><xsl:value-of select="$rowNum"/></span>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="TotQlfyCrbnOxdDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="TotQlfyCrbnOxdDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="TotNonQlfyOxdDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="TotNonQlfyOxdDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="TotAllCrbnOxdSuprDlvrUtlzGrp/DeliveredQty"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="border-right-width:0px;">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="TotAllCrbnOxdSuprDlvrUtlzGrp/UtilizedQty"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
									<tr style="vertical-align:bottom;">
										<td class="styTableCellTextInherit">
											Total 
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/AllTotQlfyCrbnOxdDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/AllTotQlfyCrbnOxdDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/AllTotNonQlfyOxdDlvrUtlzGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/AllTotNonQlfyOxdDlvrUtlzGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/AllTotCrbnOxdDlvrUtlzSuprGrp/DeliveredQty"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit" style="border-right-width:0px;">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="$FormData/AllTotCrbnOxdDlvrUtlzSuprGrp/UtilizedQty"/>
											</xsl:call-template>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</xsl:if>					
				</form>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="FillBusinessName">
		<xsl:param name="TargetBusinessName"/>	
			<xsl:call-template name="PopulateText">
				<xsl:with-param name="TargetNode" select="$TargetBusinessName/BusinessNameLine1Txt"/>
			</xsl:call-template>
			<xsl:if test="$TargetBusinessName/BusinessNameLine2Txt">
				<br/>
				<xsl:call-template name="PopulateText">
					<xsl:with-param name="TargetNode" select="$TargetBusinessName/BusinessNameLine2Txt"/>
				</xsl:call-template>
			</xsl:if>	
	</xsl:template>
	<xsl:template name="FillNameChoice">
		<xsl:param name="TargetBusinessName"/>
		<xsl:param name="TargetPersonName"/>
		<xsl:choose>
			<xsl:when test="$TargetBusinessName">
				<xsl:call-template name="PopulateText">
					<xsl:with-param name="TargetNode" select="$TargetBusinessName/BusinessNameLine1Txt"/>
				</xsl:call-template>
				<xsl:if test="$TargetBusinessName/BusinessNameLine2Txt">
					<br/>
					<xsl:call-template name="PopulateText">
						<xsl:with-param name="TargetNode" select="$TargetBusinessName/BusinessNameLine2Txt"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="PopulateText">
					<xsl:with-param name="TargetNode" select="$TargetPersonName"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FillPart1Table1">
		<xsl:param name="LineNumber"/>
		<xsl:param name="SepMessage" select="false()"/>
		<xsl:param name="MaxLine" select="4"/>
		<xsl:param name="RowID" select="true()"/>
		<tr style="font-size:7pt;vertical-align:bottom;">
		    <td class="styTableCellCtrInherit" style="text-align:left;font-weight:bold;border-right-width:0px;padding-left:0px;">
				<xsl:choose>
					<xsl:when test="not($RowID)">&nbsp;</xsl:when>
					<xsl:when test="$SepMessage">A</xsl:when>
					<xsl:otherwise>
						<xsl:number format="A" value="$LineNumber"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellTextInherit">
				<xsl:choose>
					<xsl:when test="$SepMessage">
                    See Additional Data Table
				</xsl:when>
					<xsl:otherwise>&nbsp;</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellTextInherit">&nbsp;</td>
			<td class="styTableCellTextInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>			
			<td class="styTableCellAmtInherit" style="border-right-width:0px;">&nbsp;</td>
		</tr>
		<xsl:choose>
			<xsl:when test="$SepMessage">
				<xsl:call-template name="FillPart1Table1">
					<xsl:with-param name="LineNumber" select="2"/>
					<xsl:with-param name="SepMessage" select="false()"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
					<xsl:with-param name="RowID" select="$RowID"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$LineNumber &lt; $MaxLine">
				<xsl:call-template name="FillPart1Table1">
					<xsl:with-param name="LineNumber" select="$LineNumber + 1"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FillPart1Table2">
		<xsl:param name="SepMessage" select="false()"/>
		<xsl:param name="LineNumber"/>
		<xsl:param name="MaxLine" select="3"/>
		<xsl:param name="RowID" select="true()"/>
		<tr style="font-size:7pt;vertical-align:bottom;">
		    <td class="styTableCellCtrInherit" style="vertical-align:middle;text-align:left;font-weight:bold;border-right-width:0px;padding-left:0px;">
				<xsl:choose>
					<xsl:when test="not($RowID)">&nbsp;</xsl:when>
					<xsl:when test="$SepMessage">A</xsl:when>
					<xsl:otherwise>
						<xsl:number format="A" value="$LineNumber"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellTextInherit">
				<xsl:choose>
					<xsl:when test="$SepMessage">
						See Additional Data Table
					</xsl:when>
					<xsl:otherwise>&nbsp;</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellTextInherit">&nbsp;</td>
			<td class="styTableCellTextInherit">&nbsp;</td>
			<td class="styTableCellTextInherit">&nbsp;</td>	
			<td class="styTableCellTextInherit">&nbsp;</td>
			<td class="styTableCellTextInherit">&nbsp;</td>		
			<td class="styTableCellCtrInherit" style="border-right-width:0px;">
				<input class="styCkbox" type="checkbox" alt="Non qualified carbon oxide supplier indicator" aria-label="Non qualified carbon oxide supplier">
					<xsl:call-template name="PopulateCheckbox">
						<xsl:with-param name="TargetNode" select="NonQlfyCrbnOxdSupplierInd"/>
						<xsl:with-param name="BackupName">Form8933SchFNonQlfyCrbnOxdSupplierInd</xsl:with-param>
					</xsl:call-template>
				</input>
			</td>
		</tr>
		<xsl:choose>
			<xsl:when test="$SepMessage">
			<xsl:call-template name="FillPart1Table2">
					<xsl:with-param name="LineNumber" select="2"/>
					<xsl:with-param name="SepMessage" select="false()"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$LineNumber &lt; $MaxLine">
				<xsl:call-template name="FillPart1Table2">
					<xsl:with-param name="LineNumber" select="$LineNumber + 1"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FillPart1Table3">
		<xsl:param name="LineNumber"/>
		<xsl:param name="SepMessage" select="false()"/>
		<xsl:param name="MaxLine" select="30"/>
		<xsl:param name="RowID" select="true()"/>
		<tr>
			<td class="styTableCellTextInherit" style="font-weight:bold;">
			<xsl:choose>
				<xsl:when test="not($RowID)">&nbsp;</xsl:when>
				<xsl:when test="$SepMessage">A</xsl:when>
				<xsl:otherwise>
					<xsl:number format="A" value="$LineNumber"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
					<xsl:when test="$SepMessage">
                    See Additional Data Table
				</xsl:when>
					<xsl:otherwise>&nbsp;</xsl:otherwise>
				</xsl:choose></td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit" style="border-right-width:0px;">&nbsp;</td>
		</tr>
		<xsl:choose>
			<xsl:when test="$SepMessage">
				<xsl:call-template name="FillPart1Table3">
					<xsl:with-param name="LineNumber" select="2"/>
					<xsl:with-param name="SepMessage" select="false()"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$LineNumber &lt; $MaxLine">
				<xsl:call-template name="FillPart1Table3">
					<xsl:with-param name="LineNumber" select="$LineNumber + 1"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FillPart1Table3Tot">
		<xsl:param name="LineNumber"/>
		<xsl:param name="SepMessage" select="false()"/>
		<xsl:param name="MaxLine" select="30"/>
		<xsl:param name="RowID" select="true()"/>
		<tr>
			<td class="styTableCellTextInherit" style="font-weight:bold;">
				<xsl:choose>
					<xsl:when test="not($RowID)">&nbsp;</xsl:when>
					<xsl:when test="$SepMessage">A</xsl:when>
					<xsl:otherwise>
						<xsl:number format="A" value="$LineNumber"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellCtrInherit">
				<xsl:choose>
					<xsl:when test="$SepMessage">
                    See Additional Data Table
				</xsl:when>
					<xsl:otherwise>&nbsp;</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit" style="border-right-width:0px;">&nbsp;</td>
		</tr>
		<xsl:choose>
			<xsl:when test="$SepMessage">
				<xsl:call-template name="FillPart1Table3Tot">
					<xsl:with-param name="LineNumber" select="2"/>
					<xsl:with-param name="SepMessage" select="false()"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$LineNumber &lt; $MaxLine">
				<xsl:call-template name="FillPart1Table3Tot">
					<xsl:with-param name="LineNumber" select="$LineNumber + 1"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
