<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"> ]>
<!-- Updated By Iskilu Lawal TY2025_IRS8933_UWR # 1003302 and 1010592__REL10.9_Drop5 09022025 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="PopulateTemplate.xsl"/>
	<xsl:include href="CommonPathRef.xsl"/>
	<xsl:include href="AddHeader.xsl"/>
	<xsl:include href="AddOnTable.xsl"/>
	<xsl:include href="IRS8933Style.xsl"/>
	<xsl:output method="html" indent="yes" encoding="iso-8859-1"/>
	<xsl:strip-space elements="*"/>
	<xsl:param name="FormData" select="$RtnDoc/IRS8933"/>
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html lang="EN-US">
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($FormData)"/>
					</xsl:call-template>
				</title>
				<!-- No Browser Caching -->
				<meta http-equiv="Pragma" content="no-cache"/>
				<meta http-equiv="Cache-Control" content="no-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private"/>
				<!-- Define Character Set -->
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
				<meta name="Description" content="IRS Form 8933"/>
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
				<xsl:call-template name="InitJS"/>
				<style type="text/css">
					<!--<xsl:if test="not($Print) or $Print=''">-->
					<xsl:call-template name="IRS8933Style"/>
					<xsl:call-template name="AddOnStyle"/>
					<!--</xsl:if>-->
				</style>
				<xsl:call-template name="GlobalStylesForm"/>
			</head>
			<body class="styBodyClass">
				<form name="Form8933">
					<xsl:call-template name="DocumentHeader"/>
					<xsl:call-template name="SetFormLinkInline">
						<xsl:with-param name="TargetNode" select="$RtnDoc/BinaryAttachment"/>
					</xsl:call-template>
					<xsl:call-template name="SetFormLinkInline">
						<xsl:with-param name="TargetNode" select="$RtnDoc/GeneralDependencySmall"/>
					</xsl:call-template>
					<div class="styStdDiv">
						<div class="styFNBox" style="width:39mm;height:18mm;">
							Form <span class="styFN" style="font-size:18pt;">8933</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData"/>
							</xsl:call-template>
							<br/>(Rev. December 2025)<br/>
							<span class="styAgency" style="padding-top:1mm;"> Department of the Treasury <br/>Internal Revenue Service</span>
						</div>
						<div class="styFTBox" style="width:114mm;height:18mm;">
							<span class="styFMT" style="font-size:12pt;padding-top:1mm;">Carbon Oxide Sequestration Credit</span>
							<br/>
							<span class="styFMT" style="font-size:7.5pt;padding-top:1mm;">Attach to your tax return.</span>
							<br/>
							<span style="font-weight:bold;">Go to <span style="font-style:italic;font-size:7.5pt;">www.irs.gov/Form8933 </span> for instructions and the latest information.</span>
						</div>
						<div class="styTYBox" style="width:33mm;height:18mm;">
							<div class="styOMB" style="font-size:7.5pt;border-bottom-width:1px; padding-top:2mm;padding-bottom:2mm;height:9mm;">OMB No. 1545-0123</div>
							<div style="text-align:left;width:100%; padding-left: 3mm; height:9mm;padding-top:3mm;">Attachment<br/>Sequence No. <span class="styBoldText">165</span>
							</div>
						</div>
					</div>
					<div class="styBB" style="width:187mm;border-top-width:1px;">
						<div class="styNameBox" style="width:145mm;height:auto;padding-bottom:1mm;font-size:7pt;">
							Name(s) shown on return<br/>
							<xsl:call-template name="PopulateReturnHeaderFiler">
								<xsl:with-param name="TargetNode">BusinessNameLine1Txt</xsl:with-param>
							</xsl:call-template>
							<br/>
							<xsl:call-template name="PopulateReturnHeaderFiler">
								<xsl:with-param name="TargetNode">BusinessNameLine2Txt</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="styEINBox" style="width:40mm;height:auto;padding-bottom:1mm;font-size:7pt;padding-left:2mm;">
							Identifying number<br/>
							<div style="text-align:left;padding-top:1.5mm;height:5mm;font-weight:normal;">
								<xsl:choose>
									<xsl:when test="$RtnHdrData/ReturnTypeCd='1040'">
										<xsl:call-template name="PopulateReturnHeaderFiler">
											<xsl:with-param name="TargetNode">PrimarySSN</xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="$RtnHdrData/ReturnTypeCd='1040NR'">
										<xsl:call-template name="PopulateReturnHeaderFiler">
											<xsl:with-param name="TargetNode">PrimarySSN</xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="PopulateReturnHeaderFiler">
											<xsl:with-param name="TargetNode">EIN</xsl:with-param>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</div>
						</div>
					</div>
					<!-- Part 1 -->
					<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
						<div class="styPartName" style="font-size:9pt;font-weight:bold;">Part I</div>
						<div class="styPartDesc" style="font-size:9pt;font-weight:bold;height:8mm;">
						Information About Facility, Carbon Capture Equipment, DAC Facility, Carbon Oxide Sequestration Types, Credit Calculation, and Your Elections</div>
					</div>
					<div class="styStdDiv" style="font-size:10pt;font-weight:bold;border-style: solid; border-color: black;
	border-top-width: 0px; border-bottom-width: 1px; border-left-width: 0px; border-right-width: 0px;">Section 1—Facility Information</div>
					<!--Part 1 Line 1-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;border-style: solid; border-color: black;
	border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px; border-right-width: 0px;height:10mm;">
							If making an elective payment election or transfer election, enter the IRS-issued registration number for the facility:
								<div class="styLNDesc" style="width:118mm;border-bottom:1px dashed black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityIRSIssdRegistrationNum"/>
							</xsl:call-template>
						</div>
						</div>
					</div>
					<!--Part 1 Line 2-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">2</div>
						<div class="styLNDesc" style="width:63mm;">Facility’s EPA e-GGRT ID number(s), if available: </div>
						<div class="styLNDesc" style="width:115mm;border-bottom:1px dashed black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityEPAeGGRTIdNum"/>
							</xsl:call-template>
						</div>
					</div>
					<!--Part 1 Line 3-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">3</div>
						<div class="styLNDesc" style="width:80mm;">Facility type. Enter GEO, EOR, or UTZ (see instructions):  </div>
						<div class="styLNAmountBox" style="width:20mm;border-top-width:1px;border-right-width:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityTypeCd"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:20mm;border-top-width:1px;border-right-width:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityTypeCd"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:20mm;border-top-width:1px;border-right-width:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityTypeCd"/>
							</xsl:call-template>
						</div>
					</div>
					<!--Part 1 Line 4a-->
					<div class="styGenericDiv">
						<div class="styLNLeftNumBoxSD" style="padding-top:1mm;">4a</div>
						<div class="styLNDesc" style="width:110mm;height:auto;">
						<div class="styLNDesc" style="width:57mm;height:auto;">
						If different than filer, enter (i) owner’s name:
							</div>
							<div class="styFixedUnderline" style="width:50mm;font-size:8pt;text-align:left">
                                           <xsl:choose>
                                                     <xsl:when test="$FormData/FacilityOwnerPersonNm">
                                                           <xsl:call-template name="PopulateText">
                                                                <xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerPersonNm"/>
                                                           </xsl:call-template><br/>
                                                         </xsl:when>
                                                     <xsl:otherwise>
                                                           <xsl:call-template name="PopulateText">
                                                                <xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerBusinessName/BusinessNameLine1Txt"/>                                         
                                                           </xsl:call-template>
                                                           <xsl:if test="$FormData/FacilityOwnerBusinessName/BusinessNameLine2Txt">
                                                                <br/>
                                                                <xsl:call-template name="PopulateText">
                                                                     <xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerBusinessName/BusinessNameLine2Txt"/>                                         
                                                                </xsl:call-template>
                                                           </xsl:if>
                                                     </xsl:otherwise>
                                                </xsl:choose>
                                     </div>
                                </div>
						<div class="styLNDesc" style="width:34mm;padding-right:2mm;height:8mm;padding-top:2mm;">and (ii) owner’s TIN:</div>
						
							<div class="styLNDesc" style="width:35mm;height:auto;float:none;padding-top:2mm;">
							<div class="styLNDesc" style="width:25mm;border-bottom:1px dashed black;margin-bottom:1px;text-align:center;">
                                  <xsl:choose>
										<xsl:when test="$FormData/FacilityOwnerEIN">
											<xsl:call-template name="PopulateEIN">
												<xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerEIN"/>
											</xsl:call-template><br/>
										    </xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="PopulateSSN">
												<xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerSSN"/>								
											</xsl:call-template>
										</xsl:otherwise>
								</xsl:choose>
							</div>
							</div>						
					</div>
					<!--Part 1 Line 5-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD" style="padding-left:4.2mm;">b</div>
						<div class="styLNDesc" style="width:48mm;height:10mm;">Address of the facility (if applicable):</div>
						<div class="styLNDesc" style="width:130mm;min-height:3.5mm;border-bottom:1px dashed black;margin-bottom:1px;height:auto;">
							<xsl:call-template name="PopulateUSAddressTemplate">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityUSAddress"/>
							</xsl:call-template>
						</div>
					</div>
					<!--Part 1 Line 4c-->
					<div class="styStdDiv" style="margin-top:1mm;">
						<div class="styLNLeftNumBoxSD" style="padding-left:4.2mm;">c</div>
						<div class="styLNDesc" style="width:40mm;">Coordinates. (i) Latitude: </div>
						<div class="styLNDesc" style="width:40mm;height:auto;">
							<div style="width:100%;border:1px solid black;text-align:center;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/FacilityLatitudeNum"/>
								</xsl:call-template>
							</div>
						</div>
						<div class="styLNDesc" style="width:40mm;padding-left:8mm;">(ii) Longitude: </div>
						<div class="styLNDesc" style="width:40mm;height:auto;">
							<div style="width:100%;border:1px solid black;text-align:center;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/FacilityLongitudeNum"/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<!--Part 1 Line 7-->
					<!-- Line 5 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">5</div>
						<div class="styLNDesc" style="width:56mm;">Date construction began (MM/DD/YYYY): </div>
						<div class="styLNDesc" style="width:38mm;border-bottom:1px solid black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateMonthDayYear">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityConstructionStartDt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 6 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="styLNDesc" style="width:56mm;">Date placed in service (MM/DD/YYYY): </div>
						<div class="styLNDesc" style="width:38mm;border-bottom:1px solid black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateMonthDayYear">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityPlacedInServiceDt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 7 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">7</div>
						<div class="styLNDesc" style="width:100mm;">Total metric tons of carbon oxide captured during the tax year: </div>
						<div class="styLNAmountBox" style="width:45mm;border-top-width:1px;border-right-width:1px;padding-right:1mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalMetricTonsCrbnOxdCptrQty"/>
							</xsl:call-template>
						</div>
					</div>
					
					
	<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
		<div class="styPartDesc" style="width:187mm;font-size:9pt;font-weight:bold;height:4mm;">
			Section 2—Industrial Facility Information
		</div>
	</div>
	
	<div class="styGenericDiv" style="width:187mm;">
		<table border="0" cellpadding="0" cellspacing="0" class="styTable" style="width:187mm; clear:both; float:none; font-size:7pt;">
			<tr>
			<!-- begin page 3 -->
				<td class="styGenericDiv" style="width:186mm; height:auto;">
					<div class="styGenericDiv" style="width:187mm;">							
						<span style="width:20mm; float:right">
							<div class="styIRS8933FYesNoBox" style="font-weight:bold; padding-top:.5mm;">Yes</div>
							<div class="styIRS8933FLFNoBox" style="font-weight:bold; padding-top:.5mm;">No</div>
						</span>
					</div>
					<!--line 8-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBoxSD" style="height:4.5mm;">8</div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Reserved for future use.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;"/>
						</span>
					</div>
					<!--End line 8-->
					<!--line 9-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBoxSD" style="height:5mm;">9</div>
										<div class="styLNDesc" style="width:150mm; height:5mm;">Is the facility an electricity-generating facility?
											<span class="styDotLn" style="float:right; padding-left:1mm;">......................</span>
										</div>
										<span style="font-weight:normal;float:right; height:5mm">
											<div class="styIRS8933FYesNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/ElectricityGeneratingInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ElectricityGeneratingInd"/>
														<xsl:with-param name="BackupName">ElectricityGeneratingInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/ElectricityGeneratingInd"/>
														<xsl:with-param name="BackupName">ElectricityGeneratingInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/ElectricityGeneratingInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ElectricityGeneratingInd"/>
														<xsl:with-param name="BackupName">ElectricityGeneratingInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/ElectricityGeneratingInd"/>
														<xsl:with-param name="BackupName">ElectricityGeneratingInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 9-->
					<!--line 10-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:5mm;">10</div>
										<div class="styLNDesc" style="width:150mm; height:5mm;">Is the facility a direct air capture (DAC) facility? If “Yes,” skip to line 16
											<span class="styDotLn" style="float:right; padding-left:1mm;">.............</span>
										</div>
										<span style="font-weight:normal;float:right; height:5mm">
											<div class="styIRS8933FYesNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/DirectAirCaptureInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/DirectAirCaptureInd"/>
														<xsl:with-param name="BackupName">DirectAirCaptureInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/DirectAirCaptureInd"/>
														<xsl:with-param name="BackupName">DirectAirCaptureInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/DirectAirCaptureInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/DirectAirCaptureInd"/>
														<xsl:with-param name="BackupName">DirectAirCaptureInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/DirectAirCaptureInd"/>
														<xsl:with-param name="BackupName">DirectAirCaptureInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 10-->
					<!--line 11-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:7mm;">11</div>				
						<div class="styLNDesc" style="width:150mm; height:8mm;">
							If the facility isn’t an electricity-generating or DAC facility, state the nature of the facility (for example, ethanol <br/> production, cement manufacturing, etc.): 
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:70%;border:1px solid black;text-align:center;">	
							</div>
							</div>	
							<!-- Facility Desc -->
												<xsl:call-template name="LinkToLeftoverDataTableInline">
										<xsl:with-param name="Desc">Part 1, Section 2, Line 11</xsl:with-param>
										<xsl:with-param name="TargetNode" select="$FormData/FacilityDesc"/>
									</xsl:call-template>		
						</div>	
						
						<span style="font-weight:normal;float:right; height:8mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:8mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:8mm;"/>
						</span>
					</div>
					<!--End line 11-->
					<!--line 12-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:5mm;">12</div>
			<div class="styLNDesc" style="width:150mm; height:5mm;">Does the facility described above process carbon dioxide or any other gas from underground deposits?
											<span class="styDotLn" style="float:right; padding-left:1mm;">.....</span>
										</div>
										<span style="font-weight:normal;float:right; height:5mm">
											<div class="styIRS8933FYesNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/ProcCrbnDxdOrOthGasInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ProcCrbnDxdOrOthGasInd"/>
														<xsl:with-param name="BackupName">ProcCrbnDxdOrOthGasInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/ProcCrbnDxdOrOthGasInd"/>
														<xsl:with-param name="BackupName">ProcCrbnDxdOrOthGasInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											
											<div class="styIRS8933FLFNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/ProcCrbnDxdOrOthGasInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="ProcCrbnDxdOrOthGasInd" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ProcCrbnDxdOrOthGasInd"/>
														<xsl:with-param name="BackupName">ProcCrbnDxdOrOthGasInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/ProcCrbnDxdOrOthGasInd"/>
														<xsl:with-param name="BackupName">ProcCrbnDxdOrOthGasInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 12-->
									
					<!--line 12a-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:10mm;">
											<span style="padding-left:3.5mm;">a</span>
										</div>
										<div class="styLNDesc" style="width:150mm; height:12mm;">
											If you answered “Yes” to line 12, was any gas obtained from a carbon dioxide production well at natural carbon <br/>
											dioxide-bearing formations or at a naturally occurring subsurface spring, which means a well that contains 90% or <br/>
											greater carbon dioxide by volume? 
											<span class="styDotLn" style="float:right; padding-left:1mm;">.........................</span>
										</div>
										<span style="font-weight:normal;float:right; height:12mm">
											<div class="styIRS8933FYesNoBox" style="height:12mm;padding-top:7mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/GasObtndCrbnDxdWellOrSprngInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/GasObtndCrbnDxdWellOrSprngInd"/>
														<xsl:with-param name="BackupName">GasObtndCrbnDxdWellOrSprngInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/GasObtndCrbnDxdWellOrSprngInd"/>
														<xsl:with-param name="BackupName">GasObtndCrbnDxdWellOrSprngInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<!--<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:5mm;"/>-->
											<div class="styIRS8933FLFNoBox" style="height:12mm;padding-top:7mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/GasObtndCrbnDxdWellOrSprngInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/GasObtndCrbnDxdWellOrSprngInd"/>
														<xsl:with-param name="BackupName">GasObtndCrbnDxdWellOrSprngInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/GasObtndCrbnDxdWellOrSprngInd"/>
														<xsl:with-param name="BackupName">GasObtndCrbnDxdWellOrSprngInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 12a-->
					<!--line 12b-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:7mm;"><span style="padding-left:3.5mm;">b</span></div>				
						<div class="styLNDesc" style="width:150mm; height:7mm;">
							If you answered “Yes” to line 12a, you can’t treat the facility as a qualified industrial facility to the extent that it  <br/>
							processed gas described on line 12a during the tax year. See line 12c.
						</div>	
						<span style="font-weight:normal;float:right; height:7mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:7mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:7mm;"/>
						</span>
					</div>
					<!--End line 12b-->
					<!--line 12c-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:14mm;">
											<span style="padding-left:3.5mm;">c</span>
										</div>
										<div class="styLNDesc" style="width:150mm; height:14mm;">
											If you answered “Yes” to line 12a, do you attest that you meet the exception for a deposit that contains a product, <br/>
											other than carbon oxide, that’s commercially viable to extract and sell without taking into account the availability of a <br/>
											commercial market for the carbon oxide that’s extracted or any carbon oxide sequestration credit (credit) that might be available? 
											<span class="styDotLn" style="float:right; padding-left:1mm;">................................</span>
										</div>
										<span style="font-weight:normal;float:right; height:14mm">
											<div class="styIRS8933FYesNoBox" style="height:14mm;padding-top:8mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AttestExceptionMetInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AttestExceptionMetInd"/>
														<xsl:with-param name="BackupName">AttestExceptionMetInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AttestExceptionMetInd"/>
														<xsl:with-param name="BackupName">AttestExceptionMetInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:14mm;padding-top:8mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AttestExceptionMetInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AttestExceptionMetInd"/>
														<xsl:with-param name="BackupName">AttestExceptionMetInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AttestExceptionMetInd"/>
														<xsl:with-param name="BackupName">AttestExceptionMetInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 12c-->

									<!--line 12d-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:10mm;">
											<span style="padding-left:3.5mm;">d</span>
										</div>
										<div class="styLNDesc" style="width:150mm; height:10mm;">
											If you answered “Yes” to line 12c, have you attached an attestment letter from an independent registered engineer? <br/>
											Don’t treat the facility as a qualified industrial facility unless you answered “Yes” to both lines 12c and 12d. <br/>See instructions 
														
					<span class="styDotLn" style="float:right; padding-left:1mm;">............................									
											</span>
										</div>
										<span style="font-weight:normal;float:right; height:10mm">
											<div class="styIRS8933FYesNoBox" style="height:10mm;padding-top:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
														<xsl:with-param name="BackupName">AttestmentLetterAttachedInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
														<xsl:with-param name="BackupName">AttestmentLetterAttachedInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:10mm;padding-top:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
														<xsl:with-param name="BackupName">AttestmentLetterAttachedInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AttestmentLetterAttachedInd"/>
														<xsl:with-param name="BackupName">AttestmentLetterAttachedInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 12d-->
															<!--line 13-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:7mm;">13</div>				
						<div class="styLNDesc" style="width:150mm; height:7mm;">
							What were the emissions of carbon oxide during the tax year (amount released to the atmosphere plus amount captured)? 
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">
							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/CarbonOxideEmissionsQty"/>
										</xsl:call-template>	
							</div>
							</div>	
						</div>	
						<span style="font-weight:normal;float:right; height:7mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:7mm;border-top-width: 0px; border-bottom-width: 0px; border-left-width: 1px; border-right-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:7mm; border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 13-->
					<!--line 13a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;padding-top:1mm">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Of the amount listed on line 13, what amount was carbon dioxide? 
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">
							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/CarbonDioxideQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;"/>
						</span>
					</div>
					<!--End line 13a-->
					<!--line 13b-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;padding-top:1.5mm">b</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Of the amount listed on line 13, what amount was carbon monoxide?
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">

							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/CarbonMonoxideQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 13b-->
					<!--line 14-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:5mm;">14</div>
										<div class="styLNDesc" style="width:150mm; height:5mm;">Were first-year carbon oxide emissions annualized for this tax year?
											<span class="styDotLn" style="float:right; padding-left:1mm;">..............</span>
										</div>
										<span style="font-weight:normal;float:right; height:5mm">
											<div class="styIRS8933FYesNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCrbnOxdFrstYrEmsnRqrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCrbnOxdFrstYrEmsnRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdCrbnOxdFrstYrEmsnRqrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCrbnOxdFrstYrEmsnRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdCrbnOxdFrstYrEmsnRqrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCrbnOxdFrstYrEmsnRqrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCrbnOxdFrstYrEmsnRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdCrbnOxdFrstYrEmsnRqrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCrbnOxdFrstYrEmsnRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdCrbnOxdFrstYrEmsnRqrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 14-->
					<!--line 14a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:7mm;"><span style="padding-left:3.5mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:7mm;">
							If you answered “Yes” to line 14, state the annualized carbon oxide emissions and attach a statement that shows how <br/>
							you determined the annualized carbon oxide emissions: 
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">

							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCarbonOxdEmissionsQty"/>
										</xsl:call-template>	
							</div>
							
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:7mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:7mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:7mm;"/>
						</span>
					</div>
					<!--End line 14a-->
					<!--line 15-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:5mm;">15</div>
										<div class="styLNDesc" style="width:150mm; height:4.5mm;">Was aggregation of multiple facilities required to achieve the requisite carbon capture thresholds?
											<span class="styDotLn" style="float:right; padding-left:1mm;">......</span>
										</div>
										<span style="font-weight:normal;float:right; height:5mm">
											<div class="styIRS8933FYesNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AggregationRqrCrbnCptrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AggregationRqrCrbnCptrInd"/>
														<xsl:with-param name="BackupName">AggregationRqrCrbnCptrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AggregationRqrCrbnCptrInd"/>
														<xsl:with-param name="BackupName">AggregationRqrCrbnCptrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AggregationRqrCrbnCptrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AggregationRqrCrbnCptrInd"/>
														<xsl:with-param name="BackupName">AggregationRqrCrbnCptrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AggregationRqrCrbnCptrInd"/>
														<xsl:with-param name="BackupName">AggregationRqrCrbnCptrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 15-->
					<!--line 15a-->
					<div class="styBB" style="width:187mm;padding-top:0mm;">
						<div class="styLNLeftNumBox" style="height:7mm;"><span style="padding-left:3.5mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:7mm;">
							If you answered “Yes” to line 15, attach a statement that lists the facilities and describes the appropriateness of their <br/>
							aggregation. 
						</div>
						<span style="font-weight:normal;float:right; height:7mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:7mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:7mm;"/>
						</span>
					</div>
					<!--End line 15a-->
				</td>
			</tr>
		</table>	
	</div>
<!-- Page Break and Footer-->
	<div class="pageEnd" style="width:187mm;padding-top:1mm;">
		<div style="float:left;">
			<span class="styBoldText">For Paperwork Reduction Act Notice, see instructions.</span>
			<span style="width:30mm;"/>                      
                Cat. No. 37748H
		</div>
						
		<div style="float:right;">
			<span style="width:40px;"/>  
      	  Form <span class="styBoldText" style="font-size:8pt;">8933</span> (Rev. 12-2025)
		</div>
						
	</div>
	<p style="page-break-before: always"/>
	<!-- END Page Break and Footer-->
	<!--Begin Page 2 -->
	<!-- Page Header -->
	<div class="styBB" style="width:187mm;padding-top:.5mm;">
		<div style="float:left;">Form 8933 (Rev. 12-2025)<span style="width:140mm;"/></div>				
		<div style="float:right;">Page <span style="font-weight:bold;font-size:8pt;">2</span></div>
	</div>
	<!-- END Page Header -->
	<!--YESand NO Line -->
	<div class="styStdDiv" style="border-top:0px solid black;border-bottom:1px solid black;">
		<div class="styPartDesc" style="width:187mm;font-size:9pt;font-weight:bold;height:4mm;">
			Section 3—Carbon Capture Equipment and DAC Facility Information
		</div>
	</div>
	<div class="styGenericDiv" style="width:187mm;">
		<table border="0" cellpadding="0" cellspacing="0" class="styTable" style="width:187mm; clear:both; float:none; font-size:7pt;">
			<tr>
			<!-- begin page 3 -->
				<td class="styGenericDiv" style="width:186mm; height:auto;">
					<div class="styGenericDiv" style="width:187mm;">							
						<span style="width:20mm; float:right">
							<div class="styIRS8933FYesNoBox" style="font-weight:bold; padding-top:.5mm;">Yes</div>
							<div class="styIRS8933FLFNoBox" style="font-weight:bold; padding-top:.5mm;">No</div>
						</span>
					</div>
									<!--line 16-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">16</div>
										<div class="styLNDesc" style="width:150mm; height:4.5mm;">Is carbon captured by a DAC facility?
											<span class="styDotLn" style="float:right; padding-left:1mm;">........................</span>
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CarbonCapturedDACFacilityInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCapturedDACFacilityInd"/>
														<xsl:with-param name="BackupName">CarbonCapturedDACFacilityInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCapturedDACFacilityInd"/>
														<xsl:with-param name="BackupName">CarbonCapturedDACFacilityInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CarbonCapturedDACFacilityInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCapturedDACFacilityInd"/>
														<xsl:with-param name="BackupName">CarbonCapturedDACFacilityInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCapturedDACFacilityInd"/>
														<xsl:with-param name="BackupName">CarbonCapturedDACFacilityInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 16-->
					<!--line 17-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;">17</div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Reserved for future use.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;"/>
						</span>
					</div>
					<!--End line 17-->
		<!--line 18-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">18</div>
										<div class="styLNDesc" style="width:150mm; height:4.5mm;">
											Was any carbon capture equipment placed in service on or after February 9, 2018, and before 2023? See instructions
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CarbonCptrEquipPlcdSrvcDtInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCptrEquipPlcdSrvcDtInd"/>
														<xsl:with-param name="BackupName">CarbonCptrEquipPlcdSrvcDtInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCptrEquipPlcdSrvcDtInd"/>
														<xsl:with-param name="BackupName">CarbonCptrEquipPlcdSrvcDtInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CarbonCptrEquipPlcdSrvcDtInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCptrEquipPlcdSrvcDtInd"/>
														<xsl:with-param name="BackupName">CarbonCptrEquipPlcdSrvcDtInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCptrEquipPlcdSrvcDtInd"/>
														<xsl:with-param name="BackupName">CarbonCptrEquipPlcdSrvcDtInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 18-->
					<!--line 19-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;">19</div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Reserved for future use.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;"/>
						</span>
					</div>
					<!--End line 19-->
					<!--line 20-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">20</div>
								<div class="styLNDesc" style="width:150mm; height:4.5mm;"> Are you the owner of the carbon capture equipment described in Section 1?
											<span class="styDotLn" style="float:right; padding-left:1mm;">............</span>
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureEquipOwnerInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureEquipOwnerInd"/>
														<xsl:with-param name="BackupName">CarbonCaptureEquipOwnerInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureEquipOwnerInd"/>
														<xsl:with-param name="BackupName">CarbonCaptureEquipOwnerInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureEquipOwnerInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureEquipOwnerInd"/>
														<xsl:with-param name="BackupName">CarbonCaptureEquipOwnerInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureEquipOwnerInd"/>
														<xsl:with-param name="BackupName">CarbonCaptureEquipOwnerInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 20-->
					<!--Begin line 20a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;padding-top:1mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							If you answered “No” to line 20, state your authority for claiming the credit:
							
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:90%;border:1px solid black;text-align:center;">
							</div>
							</div>
							<xsl:call-template name="LinkToLeftoverDataTableInline">
										<xsl:with-param name="Desc">Part I, Section 3, Line 20a</xsl:with-param>
										<xsl:with-param name="TargetNode" select="$FormData/ClaimingCreditAuthorityTxt"/>
									</xsl:call-template>

						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 20a-->
					<!--line 21-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;">21</div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Reserved for future use.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 21-->
					<!--line 22-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:7mm;">22</div>				
						<div class="styLNDesc" style="width:150mm; height:7mm;">
							For the carbon capture equipment described in Section 1, what was the carbon capture capacity on or after <br/> February 9, 2018?
							
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">

							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/CarbonCaptureCapacityQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:7mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:7mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:7mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 22-->
	<!--line 23-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">23</div>
										<div class="styLNDesc" style="width:150mm; height:4.5mm;">Was additional equipment installed on or after February 9, 2018?
											<span class="styDotLn" style="float:right; padding-left:1mm;">..............</span>
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AddnlEquipInstalledInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AddnlEquipInstalledInd"/>
														<xsl:with-param name="BackupName">CarbonCaptureEquipOwnerInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AddnlEquipInstalledInd"/>
														<xsl:with-param name="BackupName">CarbonCaptureEquipOwnerInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AddnlEquipInstalledInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AddnlEquipInstalledInd"/>
														<xsl:with-param name="BackupName">AddnlEquipInstalledInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AddnlEquipInstalledInd"/>
														<xsl:with-param name="BackupName">AddnlEquipInstalledInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 23-->
					<!--Begin line 23a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Reserved for future use.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 23a-->
					<!--Begin line 23b-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;">b</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Reserved for future use.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey"/>
						</span>
					</div>
					<!--End line 23b-->
									<!--line 23c-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">
											<span style="padding-left:3.5mm;">c</span>
										</div>
										<div class="styLNDesc" style="width:150mm; height:4.5mm;font-size:9px;">
											Is the placed-in-service date of the carbon capture equipment described on line 23 determined pursuant to the 80/20 rule?
												<!--<span class="styDotLn" style="float:right; padding-left:1mm;">.</span>-->
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/PlcdSrvcDtCrbnCptrEquipRuleInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/PlcdSrvcDtCrbnCptrEquipRuleInd"/>
														<xsl:with-param name="BackupName">PlcdSrvcDtCrbnCptrEquipRuleInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/PlcdSrvcDtCrbnCptrEquipRuleInd"/>
														<xsl:with-param name="BackupName">PlcdSrvcDtCrbnCptrEquipRuleInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/PlcdSrvcDtCrbnCptrEquipRuleInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/PlcdSrvcDtCrbnCptrEquipRuleInd"/>
														<xsl:with-param name="BackupName">PlcdSrvcDtCrbnCptrEquipRuleInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/PlcdSrvcDtCrbnCptrEquipRuleInd"/>
														<xsl:with-param name="BackupName">PlcdSrvcDtCrbnCptrEquipRuleInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 23c-->
					<!--Begin line 23d-->
					<div class="styGenericDiv" style="clear:both;width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;">d</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							If you answered “Yes” to line 23c, state your investment in:
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 23d-->
					<!--Begin line 23d (i)-->
					<div class="styGenericDiv" style="clear:both;width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:7.5mm;">(i)</span></div>				
						<div class="styLNDesc" style="width:140mm; height:4.5mm;padding-left:5mm;">
							New carbon capture equipment
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">.................</span>
							<div class="styFixedUnderline" style="width:25mm;float:none;padding-bottom:0mm;padding-top:0mm;">

							<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/NewCarbonCptrEquipInvstAmt"/>
										</xsl:call-template>	
							</div>
							</div>
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 23d (i)-->
					<!--Begin line 23d (ii)-->
					<div class="styGenericDiv" style="clear:both;width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:7.5mm;">(ii)</span></div>				
						<div class="styLNDesc" style="width:140mm; height:4.5mm;padding-left:5mm;">
							The far market value of pre-existing carbon capture equipment 
							
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">.......</span>
							<div class="styFixedUnderline" style="width:25mm;float:none;padding-bottom:0mm;padding-top:0mm;">

							<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/FMVPreExistCarbonCptrEquipAmt"/>
										</xsl:call-template>	
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 23d (ii)-->
					<!--line 23e-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:8mm;">
											<span style="padding-left:3.5mm;">e</span>
										</div>
										<div class="styLNDesc" style="width:150mm; height:8mm;">
											If the placed-in-service date of the carbon capture equipment was determined pursuant to the 80/20 rule, did you include 
							its investment in a transportation pipeline as new carbon capture equipment?
											<span class="styDotLn" style="float:right; padding-left:1mm;">..........</span>
										</div>
										<span style="font-weight:normal;float:right; height:8mm">
											<!--<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:5mm;"/>-->
											<div class="styIRS8933FYesNoBox" style="height:8mm;padding-top:3mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/InvstPplnNewCrbnCptrEquipInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/InvstPplnNewCrbnCptrEquipInd"/>
														<xsl:with-param name="BackupName">InvstPplnNewCrbnCptrEquipInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/InvstPplnNewCrbnCptrEquipInd"/>
														<xsl:with-param name="BackupName">InvstPplnNewCrbnCptrEquipInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<!--<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:5mm;"/>-->
											<div class="styIRS8933FLFNoBox" style="height:8mm;padding-top:3mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/InvstPplnNewCrbnCptrEquipInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/InvstPplnNewCrbnCptrEquipInd"/>
														<xsl:with-param name="BackupName">InvstPplnNewCrbnCptrEquipInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/InvstPplnNewCrbnCptrEquipInd"/>
														<xsl:with-param name="BackupName">InvstPplnNewCrbnCptrEquipInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 23e-->
					<!--Begin line 23f-->
					<div class="styGenericDiv" style="clear:both;width:187mm;">
						<div class="styLNLeftNumBox" style="height:5mm;"><span style="padding-left:3.5mm;padding-top:1.5mm;">f</span></div>				
						<div class="styLNDesc" style="width:158mm; height:5mm;">
							If you answered “Yes” to line 23e, state your investment in a transportation pipeline:
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">
							<xsl:call-template name="PopulateAmount">
											<xsl:with-param name="TargetNode" select="$FormData/InvstTransPipelineAmt"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:5mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:5mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 23f-->
					<!--line 24-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;padding-top:2mm;">24</div>				
						<div class="styLNDesc" style="width:159mm; height:5mm;">
							What was the total amount of carbon oxide captured during the calendar year (in metric tons)?
							<div class="styLNDesc" style="width:38mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">
							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/TotMtrcTonsCrbnOxdCptrEquipQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:5mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:5mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 24-->
					<!--line 24a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;padding-top:1mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Of the amount listed on line 24, what amount was carbon dioxide? 
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">

							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/CarbonDioxideCptrEquipQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 24a-->
					<!--line 24b-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;padding-top:1.5mm;">b</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							Of the amount listed on line 24, what amount was carbon monoxide?
							
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">

							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/CarbonMonoxideCptrEquipQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:4.5mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:4.5mm;"/>
						</span>
					</div>
					<!--End line 24b-->
					<!--line 25-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">25</div>
									<div class="styLNDesc" style="width:150mm; height:4.5mm;">Were first-year carbon oxide emissions annualized for this tax year?
											<span class="styDotLn" style="float:right; padding-left:1mm;">................</span>
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AnnlzdFrstYrCrbnOxdCptrRqrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdFrstYrCrbnOxdCptrRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdFrstYrCrbnOxdCptrRqrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdFrstYrCrbnOxdCptrRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdFrstYrCrbnOxdCptrRqrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AnnlzdFrstYrCrbnOxdCptrRqrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdFrstYrCrbnOxdCptrRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdFrstYrCrbnOxdCptrRqrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AnnlzdFrstYrCrbnOxdCptrRqrInd"/>
														<xsl:with-param name="BackupName">AnnlzdFrstYrCrbnOxdCptrRqrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 25-->
					<!--line 25a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:5mm;"><span style="padding-left:3.5mm;padding-top:1mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:5mm;">
							If you answered “Yes” to line 25, state the annualized carbon oxide emissions:
							<div class="styLNDesc" style="width:40mm;height:auto;float:none;">
							<div style="width:100%;border:1px solid black;text-align:center;">
							<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/AnnlzdCarbonOxdEmsnCptrQty"/>
										</xsl:call-template>	
							</div>
							</div>
						</div>	
						<span style="font-weight:normal;float:right; height:5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:5mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:5mm;"/>
						</span>
					</div>
					<!--End line 25a-->
				</td>
			</tr>
		</table>
	</div>
    <div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
		<div class="styPartDesc" style="width:187mm;font-size:9pt;font-weight:bold;height:4mm;">
			Section 4—Information About Carbon Oxide Sequestration Credit and Your Elections
		</div>
	</div>
    <div class="styGenericDiv" style="width:187mm;">
		<table border="0" cellpadding="0" cellspacing="0" class="styTable" style="width:187mm; clear:both; float:none; font-size:7pt;">
			<tr>
			<!-- begin page 3 -->
				<td class="styGenericDiv" style="width:186mm; height:auto;">
					<div class="styGenericDiv" style="width:187mm;">							
						<span style="width:20mm; float:right">
							<div class="styIRS8933FYesNoBox" style="font-weight:bold; padding-top:.5mm;">Yes</div>
							<div class="styIRS8933FLFNoBox" style="font-weight:bold; padding-top:.5mm;">No</div>
						</span>
					</div>
					<!--line 26-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:7mm;">26</div>
										<div class="styLNDesc" style="width:150mm; height:7mm;">During the tax year, are other parties contractually ensuring disposal, injection, or utilization of qualified carbon  oxide captured at this facility?
											<span class="styDotLn" style="float:right; padding-left:1mm;">.............................</span>
										</div>
										<span style="font-weight:normal;float:right; height:7mm">
											<div class="styIRS8933FYesNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/DispInjctUtlzQlfyCrbnOxdInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/DispInjctUtlzQlfyCrbnOxdInd"/>
														<xsl:with-param name="BackupName">DispInjctUtlzQlfyCrbnOxdInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/DispInjctUtlzQlfyCrbnOxdInd"/>
														<xsl:with-param name="BackupName">DispInjctUtlzQlfyCrbnOxdInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/DispInjctUtlzQlfyCrbnOxdInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/DispInjctUtlzQlfyCrbnOxdInd"/>
														<xsl:with-param name="BackupName">DispInjctUtlzQlfyCrbnOxdInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/DispInjctUtlzQlfyCrbnOxdInd"/>
														<xsl:with-param name="BackupName">DispInjctUtlzQlfyCrbnOxdInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 26-->
					<!--line 27-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">27</div>
										<div class="styLNDesc" style="width:150mm; height:4.5mm;">For this tax year, do you elect to allow any of the parties described on line 26 to claim some or all of the credit?
											<span class="styDotLn" style="float:right; padding-left:1mm;">..</span>
										</div>
										<span style="font-weight:normal;float:right; height:4.5mm">
											<div class="styIRS8933FYesNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AllowPartiesClmSomeOrAllCrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AllowPartiesClmSomeOrAllCrInd"/>
														<xsl:with-param name="BackupName">AllowPartiesClmSomeOrAllCrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/AllowPartiesClmSomeOrAllCrInd"/>
														<xsl:with-param name="BackupName">AllowPartiesClmSomeOrAllCrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:4.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/AllowPartiesClmSomeOrAllCrInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/AllowPartiesClmSomeOrAllCrInd"/>
														<xsl:with-param name="BackupName">AllowPartiesClmSomeOrAllCrInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/AllowPartiesClmSomeOrAllCrInd"/>
														<xsl:with-param name="BackupName">AllowPartiesClmSomeOrAllCrInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 27-->
					<!--line 28-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:7mm;">28</div>
										<div class="styLNDesc" style="width:150mm; height:7mm;">Do you elect under section 45Q(b)(3) to apply the $10 and $20 rates (adjusted for inflation) instead of the applicable dollar amounts?
											<span class="styDotLn" style="float:right; padding-left:1mm;">...............................</span>
										</div>
										<span style="font-weight:normal;float:right; height:7mm">
											<div class="styIRS8933FYesNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/Sect45Qb3RtsApplcblDolAmtInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/Sect45Qb3RtsApplcblDolAmtInd"/>
														<xsl:with-param name="BackupName">Sect45Qb3RtsApplcblDolAmtInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/Sect45Qb3RtsApplcblDolAmtInd"/>
														<xsl:with-param name="BackupName">Sect45Qb3RtsApplcblDolAmtInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/Sect45Qb3RtsApplcblDolAmtInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/Sect45Qb3RtsApplcblDolAmtInd"/>
														<xsl:with-param name="BackupName">Sect45Qb3RtsApplcblDolAmtInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/Sect45Qb3RtsApplcblDolAmtInd"/>
														<xsl:with-param name="BackupName">Sect45Qb3RtsApplcblDolAmtInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 28-->
					<!--line 28a-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:7mm;"><span style="padding-left:3.5mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:7mm;">
							If you answered “Yes” to line 28, determine the credit using $28.43 on Part III, line 1g; and $14.21 on Part III, line 2g <br/>
							or 3g, for tax years beginning in 2025. See instructions for the inflation-adjusted rates applicable in later tax years.
						</div>	
						<span style="font-weight:normal;float:right; height:7mm;">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:7mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:7mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 28a-->
					<!--line 28b-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:10mm;"><span style="padding-left:3.5mm;">b</span></div>				
						<div class="styLNDesc" style="width:150mm; height:10mm;">
							If you answered “No” to line 28 and your carbon capture facility and equipment were placed in service before 2023, <br/>
							determine the credit using $XX.XX on Part III, line 1g; and $XX.XX on Part III, line 2g or 3g, for tax years beginning in <br/>
							2025. See Notice 2018-93 for the applicable dollar amounts in later tax years.
						</div>	
						<span style="font-weight:normal;float:right; height:10mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:10mm;border-bottom-width: 0px;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:10mm;border-bottom-width: 0px;"/>
						</span>
					</div>
					<!--End line 28b-->
					<!--line 28c-->
					<div class="styBB" style="width:187mm;padding-top:0mm;">
						<div class="styLNLeftNumBox" style="height:10mm;"><span style="padding-left:3.5mm;">c</span></div>				
						<div class="styLNDesc" style="width:150mm; height:10mm;">
							If you answered “No” to line 28 and your carbon capture equipment was placed in service after 2022, determine the <br/>
							credit using $17 on Part III, line 1g; and $12 on Part III, line 2g or 3g. For a DAC facility, determine the credit using <br/>
							$36 on Part III, line 1g; and $26 on Part III, line 2g or 3g.
						</div>	
						<span style="font-weight:normal;float:right; height:10mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;height:10mm;"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;height:10mm;"/>
						</span>
					</div>
					<!--End line 28c-->
				</td>
			</tr>
		</table>
	</div>
	<!--Begin in here-->
	<div class="styGenericDiv" style="width:187mm;">
		<table border="0" cellpadding="0" cellspacing="0" class="styTable" style="width:187mm; clear:both; float:none; font-size:7pt;">
			<tr>
			<!-- begin page 3 -->
				<td class="styGenericDiv" style="width:186mm; height:auto;">
					<div class="styGenericDiv" style="width:187mm;">							
						<span style="width:20mm; float:right">
							<div class="styIRS8933FYesNoBox" style="font-weight:bold; padding-top:.5mm;">Yes</div>
							<div class="styIRS8933FLFNoBox" style="font-weight:bold; padding-top:.5mm;">No</div>
						</span>
					</div>	
					<!--line 29-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:7mm;">29</div>
										<div class="styLNDesc" style="width:150mm; height:7mm;">Is the facility described in Section 1 an applicable facility and are you making the election under section 45Q(f)(6)? <br/>
							See instructions 
											<span style=" letter-spacing:3.1mm; font-weight:bold; ">................................</span>
										</div>
										<span style="font-weight:normal;float:right; height:7mm">
											<div class="styIRS8933FYesNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/ApplcblFcltyElectSect45Qf6Ind"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ApplcblFcltyElectSect45Qf6Ind"/>
														<xsl:with-param name="BackupName">ApplcblFcltyElectSect45Qf6Ind</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/ApplcblFcltyElectSect45Qf6Ind"/>
														<xsl:with-param name="BackupName">ApplcblFcltyElectSect45Qf6Ind</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/ApplcblFcltyElectSect45Qf6Ind"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/ApplcblFcltyElectSect45Qf6Ind"/>
														<xsl:with-param name="BackupName">ApplcblFcltyElectSect45Qf6Ind</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/ApplcblFcltyElectSect45Qf6Ind"/>
														<xsl:with-param name="BackupName">ApplcblFcltyElectSect45Qf6Ind</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 29-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;">a</span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							 If you answered “Yes” to line 29, determine the credit using the same rates listed on line 28b. 
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey"/>
						</span>
					</div>
					<!--line 30-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">30</div>
										<div class="styLNDesc" style="width:150mm; height:7mm;">Does the facility capture qualified carbon oxide and dispose of it in secure geological storage?<span class="styDotLn" style="float:right; padding-left:1mm;">.......</span>
										<br/>
If you answered “Yes” to line 30, use Part III, line 1, to figure your credit amounts for disposal.
										</div>
										<span style="font-weight:normal;float:right; height:7mm">
											<div class="styIRS8933FYesNoBox" style="height:7mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CptrQlfyCrbnOxdDisposStorInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CptrQlfyCrbnOxdDisposStorInd"/>
														<xsl:with-param name="BackupName">CptrQlfyCrbnOxdDisposStorInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/CptrQlfyCrbnOxdDisposStorInd"/>
														<xsl:with-param name="BackupName">CptrQlfyCrbnOxdDisposStorInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:7mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/CptrQlfyCrbnOxdDisposStorInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/CptrQlfyCrbnOxdDisposStorInd"/>
														<xsl:with-param name="BackupName">CptrQlfyCrbnOxdDisposStorInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/CptrQlfyCrbnOxdDisposStorInd"/>
														<xsl:with-param name="BackupName">CptrQlfyCrbnOxdDisposStorInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 30-->
										<!--line 31-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:7mm;">31</div>
					<div class="styLNDesc" style="width:150mm; height:7mm;">Does the facility capture qualified carbon oxide, use it as a tertiary injectant in a qualified enhanced oil or natural
gas recovery project, and dispose of it in secure geological storage?
											<span style=" letter-spacing:3.1mm; font-weight:bold; ">.................</span>
										</div>
										<span style="font-weight:normal;float:right; height:7mm">
											<div class="styIRS8933FYesNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdTrtryInjctStorInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdTrtryInjctStorInd"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdTrtryInjctStorInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdTrtryInjctStorInd"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdTrtryInjctStorInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:7mm;padding-top:2mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdTrtryInjctStorInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdTrtryInjctStorInd"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdTrtryInjctStorInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdTrtryInjctStorInd"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdTrtryInjctStorInd</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 31-->
					<div class="styGenericDiv" style="width:187mm;">
						<div class="styLNLeftNumBox" style="height:4.5mm;"><span style="padding-left:3.5mm;"></span></div>				
						<div class="styLNDesc" style="width:150mm; height:4.5mm;">
							If you answered “Yes” to line 31, use Part III, line 2, to figure your credit amounts for injection.
						</div>	
						<span style="font-weight:normal;float:right; height:4.5mm">
							<div class="styIRS8933FYesNoBox" style="background-color:lightgrey"/>
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey"/>
						</span>
					</div>
					<!--line 32-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:4.5mm;">32</div>
										<div class="styLNDesc" style="width:150mm; height:7mm;">Does the facility capture qualified carbon oxide and utilize it as described in section 45Q(f)(5)?
							<span class="styDotLn" style="float:right; padding-left:1mm;">.......</span>
										<br/>
If you answered “Yes” to line 32, use Part III, line 3, to figure your credit amounts for utilization.							
										</div>
										<span style="font-weight:normal;float:right; height:7mm">
											<div class="styIRS8933FYesNoBox" style="height:7mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdUtlzSect45Qf5Ind"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdUtlzSect45Qf5Ind"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdUtlzSect45Qf5Ind</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdUtlzSect45Qf5Ind"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdUtlzSect45Qf5Ind</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:7mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdUtlzSect45Qf5Ind"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdUtlzSect45Qf5Ind"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdUtlzSect45Qf5Ind</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdUtlzSect45Qf5Ind"/>
														<xsl:with-param name="BackupName">QlfyCrbnOxdUtlzSect45Qf5Ind</xsl:with-param>
													</xsl:call-template>												
												</label>
											</div>
										</span>
									</div>
									<!--End line 32-->
					<!--line 33-->
									<div class="styGenericDiv" style="width:187mm;">
										<div class="styLNLeftNumBox" style="height:9.5mm;">33</div>
										<div class="styLNDesc" style="width:158.5mm; height:9.5mm;border-bottom:1px solid black;">Does the facility meet the prevailing wage and apprenticeship (PWA) requirement?
							<span class="styDotLn" style="float:right; padding-left:1mm;">..........</span>
										<br/>
If you answered “Yes” to line 33, you may qualify for an increased credit amount. See instructions for Part III, 
						lines 1i, 2i, and 3i.										</div>
						
						
										<span style="font-weight:normal;float:right; height:9.5mm">
											<div class="styIRS8933FYesNoBox" style="height:9.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/PWARequirementMetInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsYes" class="styCkbox">
													<xsl:call-template name="PopulateYesCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/PWARequirementMetInd"/>
														<xsl:with-param name="BackupName">PWARequirementMetInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelYes">
														<xsl:with-param name="TargetNode" select="$FormData/PWARequirementMetInd"/>
														<xsl:with-param name="BackupName">PWARequirementMetInd</xsl:with-param>
													</xsl:call-template>												
												</label>
													<div class="styIRS8933FYesNoBox" style="background-color:lightgrey;border-bottom:0px;border-left-width: 0px;"/>
											</div>
											<div class="styIRS8933FLFNoBox" style="height:9.5mm;">
												<!-- Checkbox -->
												<xsl:call-template name="PopulateSpan">
													<xsl:with-param name="TargetNode" select="$FormData/PWARequirementMetInd"/>
												</xsl:call-template>
												<input type="Checkbox" alt="IndividualEarningsNo" class="styCkbox">
													<xsl:call-template name="PopulateNoCheckbox">
														<xsl:with-param name="TargetNode" select="$FormData/PWARequirementMetInd"/>
														<xsl:with-param name="BackupName">PWARequirementMetInd</xsl:with-param>
													</xsl:call-template>
												</input>
												<label>
													<xsl:call-template name="PopulateLabelNo">
														<xsl:with-param name="TargetNode" select="$FormData/PWARequirementMetInd"/>
														<xsl:with-param name="BackupName">PWARequirementMetInd</xsl:with-param>
													</xsl:call-template>												
												</label>
						
							<div class="styIRS8933FLFNoBox" style="background-color:lightgrey;border-bottom:0px;border-left-width: 0px; border-right-width: 1px; "/>
			
											</div>
										</span>
										
									</div>
									
									<!--End line 33-->
				</td>
			</tr>
		</table>
	</div>	
	<!--End of the table display-->				
					<div class="pageEnd" style="width:187mm;padding-top:1mm;clear:all;float:none; border-top:1px solid black;">
						<div style="float:right;">
							<!--<span style="width:40px;"/>-->  
						 Form <span class="styBoldText" style="font-size:8pt;">8933</span> (Rev. 12-2025)
						</div>
					</div>
					<!--Begin Page 3 -->
					<!-- Page Header -->
					<div class="styBB" style="width:187mm;padding-top:.5mm;float:none;">
						<div style="float:left;">Form 8933 (Rev. 12-2025)<span style="width:110mm;"/></div>
						<div style="float:right;">Page <span style="font-weight:bold;font-size:8pt;">3</span></div>
					</div>
					<!-- Part II -->
					<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
						<div class="styPartName" style="font-size:9pt;font-weight:bold;">Part II</div>
						
						<div class="styPartDesc" style="font-size:9pt;font-weight:normal;">Information About You</div>
					</div>

	<div class="styStdDiv" style="font-size:8pt;font-weight:bold;">Check the applicable box(es).</div>
	<!--Part II Line 1-->
		<div class="styStdDiv">
			<div class="styLNLeftNumBoxSD">1</div>
			<div class="styLNDesc" style="width:175mm;font-weight:normal;">
				You have obtained an analysis of lifecycle greenhouse gas emissions (LCA) approved by the IRS
				<span style=" letter-spacing:3.1mm; font-weight:bold; ">.............</span>
			</div>
			<input type="checkbox" class="styCkboxNM" style="float:right;" alt="Lifecycle greenhouse gas emissions (LCA)">
				<xsl:call-template name="PopulateCheckbox">
					<xsl:with-param name="TargetNode" select="$FormData/LCAInd"/>
					<xsl:with-param name="BackupName">F8933/LCAInd</xsl:with-param>
				</xsl:call-template>
			</input>
		</div>
					<!--Part II Line 2-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">2</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							You physically or contractually ensured the capture of qualified carbon oxide during the tax year
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">.............</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="float:right;" alt="Capture Qualified Carbon Oxide Ind">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/CaptureQualifiedCarbonOxideInd"/>
								<xsl:with-param name="BackupName">F8933/CaptureQualifiedCarbonOxideInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</div>
					<!--Part II Line 3-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">3</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							You physically or contractually ensured the disposal, usage as a tertiary injectant in a qualified enhanced oil or natural gas
						</div>
						<div class="styLNDesc" style="width:183mm;font-weight:normal;padding-left:8mm;">
							 recovery project, or utilization of captured qualified carbon oxide during the tax year
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">.................</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="padding-top:3mm;float:right;" alt="physically disposed captured qualified carbon oxide">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/PhysclDisposCptrQlfyCrbnOxdInd"/>
								<xsl:with-param name="BackupName">F8933/PhysclDisposCptrQlfyCrbnOxdInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</div>
					<!--Part II Line 4-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">4</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							You elected to allow another taxpayer to claim the carbon oxide sequestration credit that you would’ve otherwise been entitled to
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">...</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="float:right;" alt="elected to allow another taxpayer to claim the carbon oxide sequestration credit">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/ElectTPClmCrbnOxdSqstrtnCrInd"/>
								<xsl:with-param name="BackupName">F8933/ElectTPClmCrbnOxdSqstrtnCrInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</div>
					<!--Part II Line 5-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">5</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							Another taxpayer elected to allow you to claim the carbon oxide sequestration credit that they would’ve otherwise been entitled to
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">..</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="float:right;" alt="taxpayer elected to allow you to claim the carbon oxide sequestration credit">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/TPElectClmCrbnOxdSqstrtnCrInd"/>
								<xsl:with-param name="BackupName">F8933/TPElectClmCrbnOxdSqstrtnCrInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</div>
					<!--Part II Line 6-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							You’re making the election under section 45Q(b)(3)
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">...........................</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="float:right;" alt="taxpayer elected to allow you to claim the carbon oxide sequestration credit">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section45Qb3ElectionInd"/>
								<xsl:with-param name="BackupName">F8933/Section45Qb3ElectionInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</div>
					<!--Part II Line 7-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">7</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							You’re making the election under section 45Q(f)(6)
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">...........................</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="float:right;" alt="taxpayer elected to allow you to claim the carbon oxide sequestration credit">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section45Qb6ElectionInd"/>
								<xsl:with-param name="BackupName">F8933/Section45Qb6ElectionInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</div>
					<!--Part II Line 8-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">8</div>
						<div class="styLNDesc" style="width:175mm;font-weight:normal;">
							You’re making the election under section 45Q(f)(9)
							<span style=" letter-spacing:3.1mm; font-weight:bold; ">...........................</span>
						</div>
						<input type="checkbox" class="styCkboxNM" style="float:right;" alt="taxpayer elected to allow you to claim the carbon oxide sequestration credit">
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="$FormData/Section45Qf9ElectionInd"/>
								<xsl:with-param name="BackupName">F8933/Section45Qf9ElectionInd</xsl:with-param>
							</xsl:call-template>
		</input>
	</div>
	<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
		<div class="styPartName" style="font-size:9pt;font-weight:bold;">Part III</div>
		<div class="styPartDesc" style="font-size:9pt;font-weight:bold;height:4mm;"> Credit Calculations</div>
	</div>	
	<div class="styStdDiv" style="border-top:0px solid black;border-bottom:0px solid black;">
		<div class="styPartDesc" style="width:187mm;font-size:8pt;height:4mm;font-weight:normal;">
		<strong>	Caution:</strong> See instructions to determine your qualification for the increased credit amounts by meeting certain requirements.</div>
	</div>
	<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
		<div class="styPartDesc" style="width:187mm;font-size:8pt;height:4mm;font-weight:normal;">
		<strong>	Note:</strong>  Enter the applicable inflation-adjusted credit rate or applicable dollar amount on line 1g, 2g, or 3g (see instructions).
		</div>
	</div>	
	<!--Begin the table display	-->
	<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
		<tr>
			<td class="styLNLeftNumBoxSD">1</td>
			<td class="styLNDesc" style="font-weight:bold;width:100mm;height:14mm; scope=row">Qualified carbon oxide captured using carbon capture equipment or DAC facility, 
					disposed of in secure geological storage, and not used as a tertiary injectant in a qualified enhanced oil or natural gas recovery project, 
					nor utilized as described in section 45Q(f)(5).
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:14mm; background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:14mm; background-color:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;"/>
					
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;padding-top:5mm;">
				<span style="width:1px;"/>
				
			</td>
		</tr>
		<!--line 1a-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">a</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Metric tons captured and measured at the point of disposal 
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;">1a
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCapturedQty"/>
					</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width: 0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 1b-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">b</span></td>
			<td class="styLNDesc" style="width:61mm;height:8mm; scope=row">
				Metric tons captured and securely stored (physically disposed) by you
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;padding-top:4mm;">1b
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:1px;padding-top:4mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCptrTaxpayerQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm; background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
				
			</td>
		</tr>
		<!--line 1c-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">c</span></td>
			<td class="styLNDesc" style="width:61mm;height:8mm; scope=row">
				Metric tons captured and securely stored (physically disposed) by another person
				<span class="styDotLn" style="float:right; padding-right:1mm;">..</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;padding-top:4mm;">1c
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:1px;padding-top:4mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCptrAnotherPersonQty"/>
					</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;background:lightgrey;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;border-top-width: 0px;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm; background:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 1d-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">d</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Add lines 1b and 1c
				<span class="styDotLn" style="float:right; padding-right:1mm;">.................</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">1d
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:1mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCptrTotQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 1e-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">e</span></td>
			<td class="styLNDesc" style="width:61mm;height:20mm; scope=row">
				Metric tons captured and securely stored (physically
				disposed) by another person and for which you allow
				that person to claim the resulting carbon oxide
				sequestration credit. See instructions for attaching
				Schedule E (Form 8933) for each disposal site
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:20mm;padding-top:16mm;">1e
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:20mm;border-bottom-width:1px;padding-top:16mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCptrAnotherClmCrQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:20mm;background:lightgrey;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:20mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:20mm; background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 1f-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">f</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Subtract line 1e from line 1d
				<span class="styDotLn" style="float:right; padding-right:1mm;">...............</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">1f
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCptrTotMnsClmCrQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 1g-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">g</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Credit rate or applicable dollar amount (see instructions)
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">1g
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/CreditRateOrApplicableDolAmt"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		
		<!--line 1h-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;height:5mm;">h</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Multiply line 1f by line 1g
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm; ">1h
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;height:5mm;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/MetricTonsCapturedCreditAmt"/>
				</xsl:call-template>
			</td>
		</tr>
		
		<!--line 1i-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">i</span></td>
			<td class="styLNDesc" style="width:139mm;height:11mm; scope=row">
				Increased credit amount for qualified facility and equipment. If you answered “Yes” to Part I, line 33,
				multiply the amount on line 1h by 5.0. Otherwise, enter the amount from line 1h. See instructions for
				attaching
				
				 Schedule A (Form 8933) and Schedule B (Form 8933)
				<span class="styDotLn" style="float:right; padding-right:1mm;">.................</span>

			</td>
			
			<td class="styIRS8933FNumBox" style="width:6mm; height:11mm; padding-top:7mm;">1i
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:7mm;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACNotUsedDispGrp/IncreasedCreditAmt"/>
				</xsl:call-template>
			</td>
		</tr>
	</table>
					<!--Begin the table display	-->
	<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
		<tr>
			<td class="styLNLeftNumBoxSD">2</td>
			<td class="styLNDesc" style="font-weight:bold;width:100mm;height:12mm; scope=row">Qualified carbon oxide captured using carbon capture equipment or DAC
facility, used as a tertiary injectant in a qualified enhanced oil or natural gas recovery project, and disposed of in secure geological storage.
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:12mm; background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:12mm; background-color:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;"/>
					
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;padding-top:5mm;">
				<span style="width:1px;"/>
				
			</td>
		</tr>
		
		<!--line 2a-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">a</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Metric tons captured and measured at the point of injection
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;">2a
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCapturedQty"/>
					</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width: 0px;">
				<span style="width:1px;"/>
					
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2b-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;padding-top:1.5mm;">b</span></td>
			<td class="styLNDesc" style="width:61mm;height:6mm;padding-top:2mm; scope=row">
				Metric tons captured and injected by you
				<span class="styDotLn" style="float:right; padding-right:1mm;">..</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:6mm;padding-top:2mm;">2b
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:6mm;border-bottom-width:1px;padding-top:2mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCptrTaxpayerQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:6mm;background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:6mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:6mm; background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2c-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">c</span></td>
			<td class="styLNDesc" style="width:61mm;height:8mm; scope=row">
				Metric tons captured and injected by another person
				<span class="styDotLn" style="float:right; padding-right:1mm;">............</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;padding-top:4mm;">2c
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:1px;padding-top:4mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCptrAnotherPersonQty"/>
					</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;background:lightgrey;">
				<!--<span style="width:1px;"/>-->
			</td>
		<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;border-top-width: 0px;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm; background:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2d-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">d</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Add lines 2b and 2c
				<span class="styDotLn" style="float:right; padding-right:1mm;">.................</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;">2d
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCptrTotQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2e-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">e</span></td>
			<td class="styLNDesc" style="width:61mm;height:17mm; scope=row">
				Metric tons captured and injected by another person
                 and for which you allow that person to claim the
                 resulting carbon oxide sequestration credit. See
                 instructions for attaching Schedule E (Form 8933) for
                  recovery project
				<span class="styDotLn" style="float:right; padding-right:1mm;">....</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:17mm;padding-top:13mm;">2e
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:17mm;border-bottom-width:1px;padding-top:13mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCptrAnotherClmCrQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:17mm;background:lightgrey;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:17mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:17mm; background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2f-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">f</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Subtract line 2e from line 2d
				<span class="styDotLn" style="float:right; padding-right:1mm;">...............</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;">2f
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCptrTotMnsClmCrQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2g-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">g</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Credit rate or applicable dollar amount (see instructions)
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;">2g
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/CreditRateOrApplicableDolAmt"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 2h-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">h</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Multiply line 2f by line 2g
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; ">2h
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/MetricTonsCapturedCreditAmt"/>
				</xsl:call-template>
			</td>
		</tr>
		<!--line 2i-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">i</span></td>
			<td class="styLNDesc" style="width:139mm;height:9mm;border-top:0px solid black;border-bottom:0px solid black; scope=row">
				Increased credit amount for qualified facility and equipment. If you answered “Yes” to Part I, line 33,
                multiply the amount on line 2h by 5.0. Otherwise, enter the amount from line 2h. See instructions for
                attaching 
                 Schedule A (Form 8933) and Schedule C (Form 8933)
				<span class="styDotLn" style="float:right; padding-right:1mm;">.................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:9mm; padding-top:6mm;border-bottom-width:0px;">2i	
			</td>
			<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:0px;padding-top:6mm;border-bottom-width:0px;height:9mm; ">
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACUsedInjectantGrp/IncreasedCreditAmt"/>
				</xsl:call-template>
			</td>
		</tr>
	</table>
	<!--End of the table display-->				
					<div class="pageEnd" style="width:187mm;padding-top:1mm;clear:all;float:none; border-top:1px solid black;">
						<div style="float:right;">
						 Form <span class="styBoldText" style="font-size:8pt;">8933</span> (Rev. 12-2025)
						</div>
					</div>
					<!--Begin Page 3 -->
					<!-- Page Header -->
					<div class="styBB" style="width:187mm;padding-top:.5mm;float:none;">
						<div style="float:left;">Form 8933 (Rev. 12-2025)<span style="width:110mm;"/></div>
						<div style="float:right;">Page <span style="font-weight:bold;font-size:8pt;">4</span></div>
					</div>
					<!-- Part III -->
					<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
						<div class="styPartName" style="font-size:9pt;font-weight:bold;">Part III</div>
						
						<div class="styPartDesc" style="font-size:9pt;font-weight:normal;"><strong>Credit Calculations</strong> (continued)</div>
					</div>
						<!--Begin the table display	-->
	<!--Begin the table display	-->
	<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
			<tr>
			<td class="styLNLeftNumBoxSD">3</td>
			<td class="styLNDesc" style="font-weight:bold;width:100mm;height:8.5mm; scope=row">Qualified carbon oxide captured using carbon capture equipment or DAC
facility, and utilized as described in section 45Q(f)(5).
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:8.5mm; background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
			
			<td class="styIRS8933FNumBox" style="width:6mm; height:8.5mm; background-color:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;"/>
					
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;padding-top:5mm;">
				<span style="width:1px;"/>
				
			</td>
		</tr>
		<!--line 3a-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">a</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Metric tons captured and measured at the point of utilization
				<span class="styDotLn" style="float:right; padding-right:1mm;">.....</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">3a
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:1mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCapturedQty"/>
					</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width: 0px;">
				<span style="width:1px;"/>
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3b-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;padding-top:1.5mm;">b</span></td>
			<td class="styLNDesc" style="width:61mm;height:9mm;padding-top:2mm; scope=row">
				Metric tons captured and physically utilized by you
				<span class="styDotLn" style="float:right; padding-right:1mm;">.............</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:9mm;padding-top:5.5mm;">3b
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:9mm;border-bottom-width:1px;padding-top:5mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCptrTaxpayerQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:9mm;background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:9mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:9mm; background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3c-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">c</span></td>
			<td class="styLNDesc" style="width:61mm;height:8mm; scope=row">
				Metric tons captured and physically utilized by another person
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;padding-top:4mm;">3c
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:1px;padding-top:4mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCptrAnotherPersonQty"/>
					</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm;background:lightgrey;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:8mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;border-top-width: 0px;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:8mm; background:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3d-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">d</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Add lines 3b and 3c
				<span class="styDotLn" style="float:right; padding-right:1mm;">.................</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">3d
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:1mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCptrTotQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3e-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">e</span></td>
			<td class="styLNDesc" style="width:61mm;height:25mm; scope=row">
				Metric tons captured and physically utilized by another
                person and for which you allow that person to claim
                the resulting carbon oxide sequestration credit
               (expressed as carbon dioxide equivalents that were
               determined pursuant to an approved LCA). See
               instructions for attaching Schedule E (Form 8933) for
                each utilization facility
				<span class="styDotLn" style="float:right; padding-right:1mm;">.........</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:25mm;padding-top:21mm;">3e
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:25mm;border-bottom-width:1px;padding-top:21mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCptrAnotherClmCrQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:25mm;background:lightgrey;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:20mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:25mm; background:lightgrey;border-bottom-width:0px">
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3f-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">f</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Subtract line 3e from line 3d
				<span class="styDotLn" style="float:right; padding-right:1mm;">...............</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm">3f
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:1mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCptrTotMnsClmCrQty"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3g-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">g</span></td>
			<td class="styLNDesc" style="width:100mm;height:9mm; scope=row">
				Enter the displacement factor approved by the Department of Energy, based on
your LCA as shown on the attachment to your LCA acceptance letter. See instructions
				<span class="styDotLn" style="float:right; padding-right:1mm;">.....................</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:9mm;padding-top:6mm">3g
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:9mm;border-bottom-width:1px;padding-top:6mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/DisplacementFctrRt"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:9mm; background-color:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		<!--line 3h-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">h</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Multiply line 3f by line 3g
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">3h
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;padding-top:1mm;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsDisplacementFctrQty"/>
				</xsl:call-template>
			</td>
		</tr>
		<!--line 3i-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">i</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Credit rate or applicable dollar amount (see instructions)
				<span class="styDotLn" style="float:right; padding-right:1mm;">......</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;">3i
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:0.8mm;padding-right:0.5mm;font-size: 6.5pt;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/CreditRateOrApplicableDolAmt"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
		
		<!--line 3j-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">j</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Multiply line 3h by line 3i
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm ">3j
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;padding-top:1mm">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/MetricTonsCapturedCreditAmt"/>
				</xsl:call-template>
			</td>
		</tr>
		<!--line 3k-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">k</span></td>
			<td class="styLNDesc" style="width:139mm;height:11mm; scope=row">
				Increased credit amount for qualified facility and equipment. If you answered “Yes” to Part I, line 33,
                multiply the amount on line 3j by 5.0. Otherwise, enter the amount from line 3j. See instructions for
                attaching
                
                 Schedule F (Form 8933) 
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:11mm; padding-top:7mm;border-bottom-width:1px;">3k
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:7mm;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/QlfyCrbnOxdDACPhysclUtlzGrp/IncreasedCreditAmt"/>
				</xsl:call-template>
			</td>
		</tr>
		<tr>
		<!--line 4-->
							<td class="styLNLeftNumBoxSD">4</td>
							<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Credit before reduction. Add lines 1i, 2i, and 3k
				<span class="styDotLn" style="float:right; padding-right:1mm;">..................</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;">4
				<span style="width:1px;font-size=7px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:1mm;height:5mm;">
								<span style="width:1px;"/>
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/CreditBeforeReductionAmt"/>
								</xsl:call-template>
							</td>
						</tr>
						<!--Credit reduction for tax-exempt bonds-->
							
							<td class="styLNDesc" style="width:147mm;height:5mm;font-weight:bold;font-size:9pt; scope=row">
				Credit reduction for tax-exempt bonds
				
				<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;font-size=7px;"/>
							</td>
							</td>
							<td class="styLNDesc" style="width:147mm;height:7mm; scope=row">
				If you used proceeds of tax-exempt bonds to finance your facility, continue to line 5a; otherwise, enter the
amount from line 4 on line 6.
				<td class="styIRS8933FNumBox" style="width:6mm; height:7mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;font-size=7px;"/>
							</td>
							</td>
							<tr>
							<!--line 5a-->
							<td class="styLNLeftNumBoxSD">5a</td>
							<td class="styLNDesc" style="width:139mm;height:5mm;font-weight:bold;font-size:9pt; scope=row">
				Divide.
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;font-size=7px;"/>
							</td>	
						</tr>
						<tr>
		<!--line 5a-->
							<td class="styLNLeftNumBoxSD"></td>
							<td class="styLNDesc" style="width:139mm;height:10mm;padding-left:1.9mm; scope=row">
				Sum, for the tax year and all prior tax years, of all proceeds of tax-exempt bonds (within the
meaning of section 103), used to finance the qualified facility, as of the close of the tax year 
<div class="styLNDesc" style="width:137mm;float:left; clear: none;padding-left: 6mm;height:1mm;">
 
						 __________________________________________________________________________=.............	
						</div>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:10mm; padding-top:6mm;border-bottom-width:1px;padding-left:1.9mm; border-bottom-width:0px;">5a
				<span style="width:1px;font-size=7px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:6mm;height:10mm;">
								<span style="width:1px;"/>
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/CalcTaxExemptBondsPct"/>
								</xsl:call-template>
							</td>
						</tr>
						<!--Credit reduction for tax-exempt bonds-->
							<td class="styLNDesc" style="width:147mm;height:7mm;padding-left:9mm; scope=row">
				Aggregate amount of additions to the capital account for the qualified facility, for the tax <br/>
year and all prior tax years, as of the close of the tax year
				<td class="styIRS8933FNumBox" style="width:6mm; height:7mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;background:lightgrey; border-bottom-width:0px;">
				<span style="width:1px;font-size=7px;"/>
							</td>
							</td>
							<!--line 5b-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">b</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Multiply line 4 by line 5a
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; ">5b
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/CreditBeforeReductionFncAmt"/>
				</xsl:call-template>
			</td>
		</tr>	
			<!--line 5c-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">c</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Multiply line 4 by 15% (0.15)
				<span class="styDotLn" style="float:right; padding-right:1mm;">.......................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; ">5c
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/CreditBeforeReductionPctAmt"/>
				</xsl:call-template>
			</td>
		</tr>				
			<!--line 5d-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;">d</span></td>
			<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Enter the smaller of line 5b or line 5c
				<span class="styDotLn" style="float:right; padding-right:1mm;">......................</span>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; ">5d
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;">
				<span style="width:1px;"/>
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/SmllrCrBfrReductionFncPctAmt"/>
				</xsl:call-template>
			</td>
		</tr>							
			<tr>
		<!--line 6-->
							<td class="styLNLeftNumBoxSD">6</td>
							<td class="styLNDesc" style="width:139mm;height:5mm; scope=row">
				Subtract line 5d from line 4
				<span class="styDotLn" style="float:right; padding-right:1mm;">.........................</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;">6
				<span style="width:1px;font-size=7px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:1mm;height:5mm;">
								<span style="width:1px;"/>
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TaxExemptBondsCrReductionAmt"/>
								</xsl:call-template>
							</td>
						</tr>				
				<!--<p style="page-break-before: always"/>	-->	
	</table>
<!--Begin the table display	-->
					<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
						<tr>
							<td class="styLNLeftNumBoxSD">7</td>
							<td class="styLNDesc" style="font-weight:bold;width:100mm;height:19mm; scope=row">Carbon oxide sequestration credit that another taxpayer elected  under <br/>
								section 45Q(f)(3)(B) to allow you to claim. See instructions for attaching 
								Schedule A (Form 8933), Schedule E (Form 8933), and Schedule F (Form 8933). Provide basic information for the three <br/> largest elections (in dollars)
								on lines 7a, 7b, and 7c; report all others on line 7e.
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:19mm; background:lightgrey; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:19mm; background-color:lightgrey; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;padding-top:5mm;">
								<span style="width:1px;"/>
							</td>
						</tr>
						<!--line -->
						<tr>
							<td class="styLNLeftNumBoxSD"></td>
							<td class="styLNDesc" style="width:100mm;height:12mm; scope=row">
							
								<div class="styTableCellHeader"  style="height:12mm;width:17mm;padding-top:1mm;border-style:solid;border-color:black;border-width:1px 1px 1px 1px;">
									(i) EIN of<br/> electing <br/>taxpayer
								</div>
								<span class="styTableCellHeader"  style="height:12mm;width:27mm;padding-top:1mm;border-style:solid;border-color:black;border-width:1px 1px 1px 0px;">
									(ii) Metric tons<br/>elected
								</span>						
								<span class="styTableCellHeader"  style="height:12mm;width:29mm;padding-top:1mm;border-style:solid;border-color:black;border-width:1px 1px 1px 0px;">
									(iii) Credit<br/>rates
								</span>						
								<div class="styTableCellHeader"  style="height:12mm;width:26mm;padding-top:1mm;border-style:solid;border-color:black;border-width:1px 1px 1px 0px;">
									(iv) Credit elected.<br/>Multiply column (ii)<br/>by column (iii).
								</div>
							
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:12mm; background:lightgrey; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:12mm; background-color:lightgrey; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;padding-top:5mm;">
								<span style="width:1px;"/>
							</td>
						</tr>
						<!--line 7a-->
						<tr>
							<td class="styLNLeftNumBoxSD">
								<span style="padding-left:1.5mm;padding-top:1mm;">a</span>
							</td>
							<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
								<span class="styTableCellHeader"  style="font-size:5pt;height:5.3mm;width:17mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 1px;">
									<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[1]/EIN"/>
								</xsl:call-template>
								</span>
								<div class="styTableCellHeader"  style="height:5.3mm;width:27mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;padding-top:1.5mm;font-size:5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[1]/MetricTonsCapturedQty"/>
								</xsl:call-template>
								</div>						
								<span class="styTableCellHeader"  style="height:5.3mm;width:29mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;font-size:5.5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[1]/CreditRateAmt"/>
								</xsl:call-template>
								</span>						
								<div class="styTableCellHeader"  style="height:5.3mm;width:26mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;font-size:5.5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[1]/CreditElectedAmt"/>
								</xsl:call-template>
								</div>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;border-bottom-width:0px;background-color:lightgrey;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width: 0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
						</tr>
						<!--line 7a-->
						
						<!--line 7b-->
						<tr>
							<td class="styLNLeftNumBoxSD">
								<span style="padding-left:1.5mm;padding-top:1mm;">b</span>
							</td>
							<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
								<span class="styTableCellHeader"  style="height:5.3mm;width:17mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 1px;font-size:5pt">
									<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[2]/EIN"/>
								</xsl:call-template>
								</span>
								<div class="styTableCellHeader"  style="height:5.3mm;width:27mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;padding-top:1.5mm;font-size:5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[2]/MetricTonsCapturedQty"/>
								</xsl:call-template>
								</div>						
								<span class="styTableCellHeader"  style="height:5.3mm;width:29mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;font-size:5.5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[2]/CreditRateAmt"/>
								</xsl:call-template>
								</span>						
								<div class="styTableCellHeader"  style="height:5.3mm;width:26mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;font-size:5.5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[2]/CreditElectedAmt"/>
								</xsl:call-template>
								</div>
								
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;border-bottom-width:0px;background-color:lightgrey;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width: 0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
						</tr>
						<!--line 7b-->
						
						<!--line 7c-->
						<tr>
							<td class="styLNLeftNumBoxSD">
								<span style="padding-left:1.5mm;padding-top:1mm;">c</span>
							</td>
							<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
								<span class="styTableCellHeader"  style="height:5.3mm;width:17mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 1px;font-size:5pt">
									<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[3]/EIN"/>
								</xsl:call-template>
								</span>
								<div class="styTableCellHeader"  style="height:5.3mm;width:27mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;padding-top:1.5mm;font-size:5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[3]/MetricTonsCapturedQty"/>
								</xsl:call-template>
								</div>						
								<span class="styTableCellHeader"  style="height:5.3mm;width:29mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;font-size:5.5pt">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[3]/CreditRateAmt"/>
								</xsl:call-template>
								</span>						
								<div class="styTableCellHeader"  style="height:5.3mm;width:26mm;padding-top:1.5mm;border-style:solid;border-color:black;border-width:0px 1px 1px 0px;font-size:5.5pt;">
									<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/LargestCOSCElectClmGrp[3]/CreditElectedAmt"/>
								</xsl:call-template>
								</div>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;border-bottom-width:0px;background-color:lightgrey;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:0px;padding-top:0.8mm;padding-right:0.5mm;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width: 0px;">
								<span style="width:1px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
						</tr>
						<!--line 7c-->
						<!--line 7d-->
		<tr>
			<td class="styLNLeftNumBoxSD"><span style="padding-left:1.5mm;height:5mm;">d</span></td>
			<td class="styLNDesc" style="width:100mm;height:5mm; scope=row">
				Add lines 7a, 7b, and 7c in column (iv)
				<span class="styDotLn" style="float:right; padding-right:1mm;">............</span>
			</td>			
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:1mm;">7d
				<!--<span style="width:1px;"/>-->
			</td>
			<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:5mm;border-bottom-width:1px;padding-top:1mm;padding-right:0.5mm;">
				<!--<span style="width:1px;"/>-->
				<xsl:call-template name="PopulateAmount">
					<xsl:with-param name="TargetNode" select="$FormData/TotLargestCOSCElectClaimAmt"/>
				</xsl:call-template>
			</td>
			<td class="styIRS8933FNumBox" style="width:6mm; height:5mm; background-color:lightgrey;border-bottom-width:0px;">
				<!--<span style="width:1px;font-size=7px;"/>-->	
			</td>
			<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
				<span style="width:1px;"/>
			</td>
		</tr>
						<!--line 7e-->
						<tr>
							<td class="styLNLeftNumBoxSD">
								<span style="padding-left:1.5mm;">e</span>
							</td>
							<td class="styLNDesc" style="width:100mm;height:6mm; scope=row">
				Report all other carbon oxide sequestration credit that another taxpayer
				elected under section 45Q(f)(3)(B) to allow you to claim. See instructions
				<span class="styDotLn" style="float:right; padding-right:1mm;">....</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:7mm;padding-top:3.5mm;">7e
				<!--<span style="width:1px;"/>-->
			</td>
							<td class="styIRS8933FRGColumnBox" style="padding-left:.5mm;height:7mm;border-bottom-width:1px;padding-top:3.5mm;padding-right:0.5mm;">
								<!--<span style="width:1px;"/>-->
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/AllOtherCOSCElectClmAmt"/>
								</xsl:call-template>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:7mm; background-color:lightgrey;border-bottom-width:0px">
								<!--<span style="width:1px;font-size=7px;"/>-->
							</td>
							<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:0px;">
								<span style="width:1px;"/>
							</td>
						</tr>
						<!--line 7f-->
						<tr>
							<td class="styLNLeftNumBoxSD">
								<span style="padding-left:1.5mm;padding-top:2mm">f</span>
							</td>
							<td class="styLNDesc" style="width:139mm;height:5mm;padding-top:2mm; scope=row">
				Add lines 7d and 7e
				<span class="styDotLn" style="float:right; padding-right:1mm;">..........................</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:5mm;padding-top:2mm ;">7f
				<!--<span style="width:1px;font-size=7px;"/>-->
			</td>
							<!--<td class="styIRS8933FRGColumnBox" style="float:none; border-bottom-width:1px;">-->
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:2mm;height:5mm;">
								<!--<span style="width:1px;"/>-->
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalCOSCElectClmAmt"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
						<tr>
							<td class="styLNLeftNumBoxSD">8</td>
							<td class="styLNDesc" style="width:139mm;height:4mm; scope=row">
				Carbon oxide sequestration credit from partnerships and S corporations (see instructions)
				<span class="styDotLn" style="float:right; padding-right:1mm;">.....</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:4mm; padding-top:1mm;border-bottom-width:1px;padding-left:1.9mm;">8
				<span style="width:1px;font-size=7px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:0mm;">
								<span style="width:1px;"/>
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/CreditAmt"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
						<tr>
							<td class="styLNLeftNumBoxSD">9</td>
							<td class="styLNDesc" style="width:139mm;height:7mm; scope=row">
				Add lines 6, 7f, and 8. Partnerships and S corporations, report this amount on Schedule K. All others,
report this amount on Form 3800, Part III, line 1x
				<span class="styDotLn" style="float:right; padding-right:1mm;">..................</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:7mm; padding-top:3.5mm;border-bottom-width:1px;padding-left:1.9mm;">9
				<span style="width:1px;font-size=7px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:1px;padding-top:3.5mm;">
								<span style="width:1px;"/>
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotalAmt"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table cellspacing="0" cellpadding="0" style="font-size:7pt; width:187mm;" border="0">
						<tr>
							<td class="styLNLeftNumBoxSD">10</td>
							<td class="styLNDesc" style="width:139mm;height:7mm; scope=row">
				Carbon oxide sequestration credit recaptured. See instructions for attaching Schedule D (Form 8933)
				and for reporting this amount in Form 4255, Part I, line 2a, column (h)
				
				<span class="styDotLn" style="float:right; padding-right:1mm;">.............</span>
							</td>
							<td class="styIRS8933FNumBox" style="width:6mm; height:7mm; padding-top:4mm;border-bottom-width:0px;padding-left:1mm;">10
				<span style="width:0px;font-size=7px;"/>
							</td>
							<td class="styIRS8933FRGColumnBox" style="width:34mm;float:none; border-bottom-width:0px;padding-top:4mm;">
								<span style="width:1px;"/>
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/CrbnOxdSqstrtnCrRcptrAmt"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<div class="styStdDiv pageEnd" style="border-top:1px solid black;">
						
						<span style="float:right;">Form <strong>8933</strong> (Rev. 12-2025)</span>
					</div>
					<!-- Additonal Data Title Bar and Button -->
					<div class="styLeftOverTitleLine" id="LeftoverData">
						<div class="styLeftOverTitle">
						   Additional Data        
						</div>
						<div class="styLeftOverButtonContainer">
							<input class="styLeftoverTableBtn" type="button" TabIndex="-1" value="Return to Form" onclick="javascript:returnToWriteInImage();"/>
						</div>
					</div>
					<!-- Additional Data Table -->
					<table class="styLeftOverTbl">
						<xsl:call-template name="PopulateCommonLeftover">
							<xsl:with-param name="TargetNode" select="$FormData"/>
							<xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
						<!-- Facility Desc -->
						<xsl:call-template name="PopulateLeftoverRow">
							<xsl:with-param name="Desc">Part 1, Section 2, Line 11</xsl:with-param>
							<xsl:with-param name="TargetNode" select="$FormData/FacilityDesc"/>
							<xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
						<!-- Claiming Credit Authority Txt -->
						<xsl:call-template name="PopulateLeftoverRow">
							<xsl:with-param name="Desc">Part I, Section 3, Line 20a</xsl:with-param>
							<xsl:with-param name="TargetNode" select="$FormData/ClaimingCreditAuthorityTxt"/>
							<xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
					
					</table>
					<br/>
				</form>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>