<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;"> 
]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="PopulateTemplate.xsl"/>
	<xsl:include href="CommonPathRef.xsl"/>
	<xsl:include href="AddHeader.xsl"/>
	<xsl:include href="AddOnTable.xsl"/>
	<xsl:include href="IRS7217Style.xsl"/>
	<xsl:output method="html" indent="yes" encoding="iso-8859-1"/>
	<xsl:strip-space elements="*"/>
	<xsl:param name="FormData" select="$RtnDoc/IRS7217"/>
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html>
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($FormData)"/>
					</xsl:call-template>
				</title>
				<!-- No Browser Caching -->
				<meta http-equiv="Pragma" content="no-cache"/>
				<meta http-equiv="Cache-Control" content="no-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private"/>
				<meta name="Description" content="IRS Form 7217"/>
				<meta name="Generator" content="IBM WebSphere Studio"/>
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
				<xsl:call-template name="InitJS"/>
				<style type="text/css">
					<!-- PRINT STATEMENT -->
					<xsl:if test="not($Print) or $Print=''">
						<xsl:call-template name="IRS7217Style"/>
						<xsl:call-template name="AddOnStyle"/>
					</xsl:if>
				</style>
				<xsl:call-template name="GlobalStylesForm"/>
			</head>
			<body class="styBodyClass">
				<form id="Form7217" style="font-family:verdana; font-size:7pt">
					<xsl:call-template name="DocumentHeader"/>
					<!-- Begin Form title and Form number section -->
					<div class="styBB" style="width:187mm;float:none;clear:both;">
						<div class="styFNBox" style="width:33mm;height:21mm;font-size:8pt;">
							Form <span class="styFormNumber">7217</span>
							<br/>
							<span style="font-size:7pt;font-weight:normal;">(December 2024)</span>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData"/>
							</xsl:call-template>
							<br/>
							<div class="styAgency" style="padding-bottom:1mm;padding-top:2mm;font-size:8pt;"> Department of the Treasury<br/>
							Internal Revenue Service</div>
						</div>
						<div class="styFTBox" style="width:123mm;">
							<div class="styMainTitle">
							  Partner's Report of Property Distributed by a Partnership</div>
							<br/>
							<br/>
							<div class="styFST" style="padding-top:0mm;font-weight:bold;">
								Attach to your tax return.
							</div>
							<div class="styFST" style="width:123mm;float:left;clear:none;padding-top:.5mm;">
								Go to  			
								<a style="text-decoration:none;color:black;" href="http://www.irs.gov/form7217" title="Link to IRS.gov">
									<i>www.irs.gov/Form7217</i>
								</a> for instructions and the latest information.
							</div>
						</div>
						<div class="styTYBox" style="width:29mm;height:21mm;padding-top:5mm;">
							<div class="styOMB" style="height:5.5mm;">OMB No. 1545-XXXX</div>
							<div class="styOMB" style="border-bottom-width:0px;text-align:left;padding-left:2.75mm;padding-top:1mm;">
								<div style="padding-top:1mm;text-align:left;font-size:7pt;">
								Attachment<br/>Sequence No. 
								<span class="styBoldText" style="font-size:9pt;">217</span>
								</div>
							</div>
						</div>
					</div>
					<div class="styStdDiv" style="border-top:1px solid black;border-bottom:1px solid black;">
						<div class="styStdDiv">
							<div class="styNameBox" style="width:142mm;font-size:7pt;">
								Partner’s name<br/>
								<xsl:choose>
									<xsl:when test="$FormData/PartnerPersonNm">											
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/PartnerPersonNm"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>	
										<xsl:call-template name="PopulateText">
											<xsl:with-param name="TargetNode" select="$FormData/PartnerBusinessName"/>
										</xsl:call-template>				
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<xsl:choose>
								<xsl:when test="$FormData/PartnerSSN">
									<div class="styEINBox" style="width:45mm;padding-left:0.5mm;font-weight:normal;font-size:7pt;">
										Partner’s TIN or SSN<br/>										
										<xsl:call-template name="PopulateSSN">
											<xsl:with-param name="TargetNode" select="$FormData/PartnerSSN"/>
										</xsl:call-template>
									</div>
								</xsl:when>
								<xsl:otherwise>
									<div class="styEINBox" style="width:45mm;padding-left:0.5mm;font-weight:normal;font-size:7pt;">
										Partner’s TIN or SSN<br/>
										<xsl:call-template name="PopulateEIN">									
											<xsl:with-param name="TargetNode" select="$FormData/PartnerEIN"/>
										</xsl:call-template>
									</div>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<div class="styStdDiv" style="border-top:1px solid black;">
							<div class="styNameBox" style="width:142mm;font-size:7pt;">
								Distributing partnership's name<br/>
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/DistributingPartnershipName/BusinessNameLine1Txt"/>
								</xsl:call-template>	
								<xsl:if test="$FormData/DistributingPartnershipName/BusinessNameLine2Txt">
								<br/>
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/DistributingPartnershipName/BusinessNameLine2Txt"/>
								</xsl:call-template>
								</xsl:if>					
							</div>
							<div class="styEINBox" style="width:45mm;padding-left:0.5mm;font-weight:normal;font-size:7pt;">
								Distributing partnership's EIN<br/>
								<xsl:call-template name="PopulateEIN">
									<xsl:with-param name="TargetNode" select="$FormData/DistributingPartnershipEIN"/>
								</xsl:call-template>
							</div>
						</div>
						<div class="styStdDiv" style="width:187mm;height:5mm;padding-left:0.5mm;font-weight:normal;font-size:7pt;border-top:1px solid black;">
							Date property was distributed to partner
							&nbsp;
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/PropertyDistributedDt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Part I -->
					<div class="styBB" style="width:187mm;height:10mm;float:none;border-top-width:0px;padding-bottom:0.0mm;padding-top:0.0mm;">
						<span class="styPartName" style="font-size:10pt;width:14mm;height:5mm;padding-top:0.5mm;padding-bottom:0.0">Part I</span>
						<span style="width:173mm;font-size:8pt;padding-top:1mm;padding-left:3mm;"><strong>Aggregate Basis of Distributed Property on Distribution Date.</strong>
						File a separate form for each date a partner <br/>
						received distributed property.</span>	
					</div>
					<!-- line 1 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">1</div>
						<div class="styLNDesc" style="height:3mm;padding-top:4mm;">
							Was this distribution in complete liquidation of the partner’s interest in the partnership?
							<span class="sty7217DotLn">.....</span>
						</div>
						<div>
							<xsl:call-template name="PopulateSpan">
								<xsl:with-param name="TargetNode" select="$FormData/DistriLiqdtPrtnrIntPrtshpInd"/>
                            </xsl:call-template>
							<input class="styCkbox" type="checkbox" style="margin-left:2px;margin-top:4mm" aria-label="Complete Liquidation Repurchases Yes">
								<xsl:call-template name="PopulateYesCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/DistriLiqdtPrtnrIntPrtshpInd"/>
									<xsl:with-param name="BackupName">IRS7217DistriLiqdtPrtnrIntPrtshpInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:2px;"/>
							<label>
								<xsl:call-template name="PopulateLabelYes">
									<xsl:with-param name="TargetNode" select="$FormData/DistriLiqdtPrtnrIntPrtshpInd"/>
									<xsl:with-param name="BackupName" select="IRS7217DistriLiqdtPrtnrIntPrtshpInd"/>
								</xsl:call-template>
								Yes
							</label>
							<input class="styCkbox" type="checkbox" style="margin-left:25px;" aria-label="Complete Liquidation Repurchases No">
								<xsl:call-template name="PopulateNoCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/DistriLiqdtPrtnrIntPrtshpInd"/>
									<xsl:with-param name="BackupName">IRS7217DistriLiqdtPrtnrIntPrtshpInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:4px;"/>
							<label>
								<xsl:call-template name="PopulateLabelNo">
									<xsl:with-param name="TargetNode" select="$FormData/DistriLiqdtPrtnrIntPrtshpInd"/>
									<xsl:with-param name="BackupName" select="IRS7217DistriLiqdtPrtnrIntPrtshpInd"/>
								</xsl:call-template>
								No
							</label>
						</div>
					</div>
					<!-- line 2 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">2</div>
						<div class="styLNDesc" style="height:3mm;padding-top:4mm;">
							Was any part of the distribution treated as a sale or exchange under section 751(b)?
							<span class="sty7217DotLn">.......</span>
						</div>
						<div>
							<xsl:call-template name="PopulateSpan">
								<xsl:with-param name="TargetNode" select="$FormData/DistriTrtdSaleExchSect751bInd"/>
                            </xsl:call-template>
							<input class="styCkbox" type="checkbox" style="margin-left:2px;margin-top:4mm" aria-label="Distribution Treated as Sale Yes">
								<xsl:call-template name="PopulateYesCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/DistriTrtdSaleExchSect751bInd"/>
									<xsl:with-param name="BackupName">IRS7217DistriTrtdSaleExchSect751bInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:2px;"/>
							<label>
								<xsl:call-template name="PopulateLabelYes">
									<xsl:with-param name="TargetNode" select="$FormData/DistriTrtdSaleExchSect751bInd"/>
									<xsl:with-param name="BackupName" select="IRS7217DistriTrtdSaleExchSect751bInd"/>
								</xsl:call-template>
								Yes
							</label>
							<input class="styCkbox" type="checkbox" style="margin-left:25px;" aria-label="Distribution Treated as Sale No">
								<xsl:call-template name="PopulateNoCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/DistriTrtdSaleExchSect751bInd"/>
									<xsl:with-param name="BackupName">IRS7217DistriTrtdSaleExchSect751bInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:4px;"/>
							<label>
								<xsl:call-template name="PopulateLabelNo">
									<xsl:with-param name="TargetNode" select="$FormData/DistriTrtdSaleExchSect751bInd"/>
									<xsl:with-param name="BackupName" select="IRS7217DistriTrtdSaleExchSect751bInd"/>
								</xsl:call-template>
								No
							</label>
						</div>
					</div>
					<!-- line 3 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">3</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Partnership’s aggregate basis in distributed property (taking into account any basis adjustments under <br/>
							section 732(d), 734(b), or 743(b)) immediately before the distribution. This line should equal the total of<br/>
							Part II, line B, column (b)
							<span class="sty7217DotLn">.........................</span>
						</div>
						<span style="padding-top:10mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:10mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotPrtshpBasisPropBfrDistriAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 4 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">4</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Adjusted basis of the partner’s interest in the partnership immediately before the distribution
							<span class="sty7217DotLn">....</span>
						</div>
						<span style="padding-top:4mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:4mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/AdjBssPrtnrIntPrtshpBfrAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 5a -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">5a</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Cash received in the distribution
							<span class="sty7217DotLn">........................</span>
						</div>
						<span style="padding-top:4mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:4mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/CashReceivedAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 5b -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD" style="padding-left:4mm;">b</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Fair market value of marketable securities (as defined in section 731(c)) received in the distribution
							<span class="sty7217DotLn">...</span>
						</div>
						<span style="padding-top:4mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:4mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/FMVMrktblSecRcvdAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 5c -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD" style="padding-left:4mm;">c</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Add lines 5a and 5b
							<span class="sty7217DotLn">............................</span>
						</div>
						<span style="padding-top:4mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:4mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/CashMrktblSecRcvdAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 6 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">6</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Enter the smaller of line 4 or line 5c
							<span class="sty7217DotLn">.......................</span>
						</div>
						<span style="padding-top:4mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:4mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/SmllrPrtnrBssCashMrktblRcvdAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 7 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">7</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Gain recognized. Subtract line 6 from line 5c. If zero, enter -0- and go to line 9
							<span class="sty7217DotLn">.........</span>
						</div>
						<span style="padding-top:4mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:4mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/RecognizedGainAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 8 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">8</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Is U.S tax required to be paid on the gain entered on line 7?
							<span class="sty7217DotLn">...............</span>
						</div>
						<div>
							<xsl:call-template name="PopulateSpan">
								<xsl:with-param name="TargetNode" select="$FormData/USTxRqrPaidRecognizedGainInd"/>
                            </xsl:call-template>
							<input class="styCkbox" type="checkbox" style="margin-left:2px;margin-top:4mm" aria-label="US tax required on gain Yes">
								<xsl:call-template name="PopulateYesCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/USTxRqrPaidRecognizedGainInd"/>
									<xsl:with-param name="BackupName">IRS7217USTxRqrPaidRecognizedGainInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:2px;"/>
							<label>
								<xsl:call-template name="PopulateLabelYes">
									<xsl:with-param name="TargetNode" select="$FormData/USTxRqrPaidRecognizedGainInd"/>
									<xsl:with-param name="BackupName" select="IRS7217USTxRqrPaidRecognizedGainInd"/>
								</xsl:call-template>
								Yes
							</label>
							<input class="styCkbox" type="checkbox" style="margin-left:25px;" aria-label="US tax required on gain No">
								<xsl:call-template name="PopulateNoCheckbox">
									<xsl:with-param name="TargetNode" select="$FormData/USTxRqrPaidRecognizedGainInd"/>
									<xsl:with-param name="BackupName">IRS7217USTxRqrPaidRecognizedGainInd</xsl:with-param>
								</xsl:call-template>
							</input>
							<span style="width:4px;"/>
							<label>
								<xsl:call-template name="PopulateLabelNo">
									<xsl:with-param name="TargetNode" select="$FormData/USTxRqrPaidRecognizedGainInd"/>
									<xsl:with-param name="BackupName" select="IRS7217USTxRqrPaidRecognizedGainInd"/>
								</xsl:call-template>
								No
							</label>
						</div>
					</div>
					<!-- line 9 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">9</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
Partner's basis in partnership interest reduced by cash received in the distribution. Subtract line 5a from line 4. If zero or less, enter -0-. See instructions if you recognized gain under section 737 as a result of the distribution.  
							<span class="sty7217DotLn">..............................</span>
						</div>
						<span style="padding-top:10mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:10mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/PrtnrBssPrtshpIntLessCashAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<!-- line 10 -->
					<div>
						<div class="styIRS7217LNLeftNumBoxSD">10</div>
						<div class="styLNDesc" style="height:5mm;padding-top:4mm;">
							Aggregate basis to be allocated to the distributed property. For a non-liquidating distribution, enter the smaller of line 3 or line 9. For a liquidating distribution, enter the amount from line 9. Line 10 should equal the total of Part II, line B, column (e).
							<span class="sty7217DotLn">....................</span>
						</div>
						<span style="padding-top:10mm;">$</span>
						<span class="sty7217AmountLine" style="padding-top:10mm;">
								<xsl:call-template name="PopulateAmount">
									<xsl:with-param name="TargetNode" select="$FormData/TotPrtnrBssAllocDistriPropAmt"/>
								</xsl:call-template>
						</span>
					</div>
					<br/>
					<br/>
					<!-- Form footer -->
					<div class="styStdDiv pageEnd" style="border-top:2px solid black;">
						<span style="font-weight:bold;font-family:Arial;">For Paperwork Reduction Act Notice, see the Instruction for Form 1065.</span>
						<span style="margin-left:20mm;">Cat. No. 94479B</span>
						<span style="float:right;">Form <span style="font-weight:bold;font-size:9pt;">7217</span> (12-2024)</span>
					</div>
					<!-- Page 2 -->
					<!-- Header -->
					<div class="styBB" style="width:256mm;float:none">
						<div style="float: left; clear: none">Form 7217 (12-2024)</div>
						<div style="float:right">
							Page <span class="styBoldText" style="font-size: 8pt">2</span>
						</div>
					</div>
					<div style="border-bottom:1px solid black;width:256mm;padding-bottom:0mm;height:4mm;">
						<div class="styPartName" style="width:16mm;">Part II</div>
						<div class="styPartDesc" style="width:160mm;height:auto;font-weight:normal;">
							<strong>Allocation of Basis of Distributed Property</strong>
						</div>
					</div>
					<!-- Table 1, cols (a)-(e) -->
					<xsl:variable name="shouldSeparateP2" select="($Print = $Separated) and (count($FormData/AllocationBssDistriPropGrp) &gt; 30)"/>
					<div class="styTableContainerLandscape" style="width:256mm;border-bottom-width:0px;" id="Part2Table">
						<xsl:call-template name="SetInitialState"/>
						<table style="display:table;border-collapse:collapse;">	
							<thead class="styTableThead" style="height:auto;">
								<tr>
									<th scope="col" style="width:5mm;font-weight:normal;"></th>
									<th class="styTableCellHeader" scope="col" style="width:90mm;font-weight:normal;">
										<strong>(a)</strong> 
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;">
										<strong>(b)</strong> 
									</th>
									<th class="styTableCellHeader" scope="col" colspan="5" style="width:86mm;font-weight:normal;">
										<strong>(c)</strong>
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;">
										<strong>(d)</strong>
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;border-right-width:0px;">
										<strong>(e)</strong> 
									</th>
								</tr>
							</thead>
							<thead>
								<tr>
									<th scope="col" rowspan="2" style="width:5mm;font-weight:normal;"></th>
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:90mm;">
											Description of distributed property <br/> (If applicable, include property code. See Pub. 946, Appendix B)
									</th>	
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:25mm;font-weight:normal;">
										Partnership’s basis in distributed property immediately before the distribution  
									</th>
									<th class="styIRS7217TableCellHeader" scope="col" colspan="5" style="width:86mm;font-weight:normal;">
										Check applicable box(es) below. See instructions.		
									</th>
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:25mm;font-weight:normal;">
										FMV of distributed property 
									</th>
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:25mm;font-weight:normal;border-right-width:0px;">
										Partner’s basis in distributed property after application of section 732 
									</th>
								</tr>
								<tr style="height:8mm;vertical-align:top;">
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(i)</strong> 732(d)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(ii)</strong> 732(f)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(iii)</strong> 734(b)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(iv)</strong>  743(b)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:18mm;font-weight:normal;">
											<strong>(v)</strong> Reserved <br /> for future use
									</th>
								</tr>		
							</thead>
							<tbody style="font-size:6pt;">
								<xsl:if test="not($shouldSeparateP2)">
									<xsl:for-each select="$FormData/AllocationBssDistriPropGrp">
										<tr style="height:5mm;">
											<xsl:if test="position() &lt; 10">
												<td>
													<span class="styLNLeftNumBoxSD" style="width:5mm;">
														<xsl:number format="1"/>
													</span>
												</td>
											</xsl:if>
											<xsl:if test="position() &gt; 9">
												<td>
													<span class="styLNLeftNumBox" style="width:5mm;">
														<xsl:number format="1"/>
													</span>
												</td>
											</xsl:if>
											<td class="styTableCellTextInherit">
												<xsl:call-template name="PopulateText">
													<xsl:with-param name="TargetNode" select="PropertyDesc"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PrtshpBasisPropBfrDistriAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect732dBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="732(d) basis adjustment">
															<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 732(d) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect732dBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect732dBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
														
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect732fBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="732(f) basis adjustment">
															<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 732(f) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect732fBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect732fBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect734bBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="734(b) basis adjustment">
															<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 734(b) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect734bBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect734bBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect743bBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="743(b) basis adjustment">
															<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 743(b) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect743bBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect743bBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit" style="background-color:lightgrey;">
												<span style="width:1px;"/>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="DistributedPropertyFMVAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit" style="border-right-width:0px;">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PrtnrBssPropAftrSect732Amt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>
								<xsl:if test="$shouldSeparateP2 or count($FormData/AllocationBssDistriPropGrp) &lt; 30">
									<xsl:call-template name="FillTable10Cols">
										<xsl:with-param name="LineNumber" select="1 + count($FormData/AllocationBssDistriPropGrp)"/>
										<xsl:with-param name="SepMessage" select="$shouldSeparateP2"/>
									</xsl:call-template>
								</xsl:if>
							</tbody>
						</table>
					</div>
					<xsl:if test="not($shouldSeparateP2)">
						<xsl:call-template name="SetInitialDynamicTableHeight">
							<xsl:with-param name="TargetNode" select="$FormData/AllocationBssDistriPropGrp"/>
							<xsl:with-param name="containerID" select=" 'Part2Table' "/>
							<xsl:with-param name="headerHeight" select="2"/>
							<xsl:with-param name="containerHeight" select="30"/>
						</xsl:call-template>
					</xsl:if>
					<!-- Line A -->
					<div style="width:256mm;">
						<div class="styLNLeftNumBox" style="height:5mm;width:5mm;border-top-width:0px;">A</div>
						<div class="styLNDesc" style="font-size:6.5pt;width:90mm;">
							If applicable, enter any totals from any attached Parts II. See instructions.
						</div>
						<div class="styLNAmountBox" style="width:25mm;height:5mm;">
						</div>
						<div class="sty7217ShadingBox"></div>
						<div class="sty7217ShadingBox"></div>
						<div class="sty7217ShadingBox"></div>
						<div class="sty7217ShadingBox"></div>
						<div class="sty7217ShadingBox" style="width:18mm;"></div>
						<div class="styLNAmountBox" style="height:5mm;width:25mm;"></div>						
						<div class="styLNAmountBox" style="height:5mm;width:25mm;"></div>	
					</div>
					<!-- Line B -->
					<div style="width:256mm;">						
						<div class="styLNLeftNumBox" style="height:5mm;width:5mm;border-top:0px;">B</div>
						<div class="styLNDesc" style="font-size:6.5pt;width:90mm;">
							Totals for all items
							<span class="sty7217DotLn">.................</span>
						</div>
						<div class="styLNAmountBox" style="height:5mm;width:25mm;border-bottom-width:0px;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotPrtshpBasisPropBfrDistriAmt"/>
							</xsl:call-template>
						</div>
						<div class="sty7217ShadingBox" style="border-bottom-width:0px;"></div>
						<div class="sty7217ShadingBox" style="border-bottom-width:0px;"></div>
						<div class="sty7217ShadingBox" style="border-bottom-width:0px;"></div>
						<div class="sty7217ShadingBox" style="border-bottom-width:0px;"></div>
						<div class="sty7217ShadingBox" style="width:18mm;border-bottom-width:0px;"></div>
						<div class="styLNAmountBox" style="height:5mm;width:25mm;border-bottom-width:0px;">
						<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotDistributedPropertyFMVAmt"/>
							</xsl:call-template></div>						
						<div class="styLNAmountBox" style="height:5mm;width:25mm;border-bottom-width:0px;">
						<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotPrtnrBssPropAftrSect732Amt"/>
							</xsl:call-template></div>	
					</div>
					<!-- Page 2 footer -->
					<div class="styStdDiv pageEnd" style="width:256mm; border-top:2px solid black;">
						<span style="float:right;">Form <strong>7217</strong> (12-2024)</span>
					</div> 
					<!-- Additonal Data Title Bar and Button -->
					<div class="styLeftOverTitleLineLandscape" id="LeftoverData">
						<div class="styLeftOverTitle">Additional Data </div> 
						<div class="styLeftOverButtonContainerLandscape">
							<input class="styLeftoverTableBtn" type="button" value="Return to Form"
							 onclick="javascript:returnToWriteInImage();"/>
						</div>
					</div>
					<!-- Additional Data Table -->
					<table class="styLeftOverTblLandscape">
						<xsl:call-template name="PopulateCommonLeftoverLandscape">
							<xsl:with-param name="TargetNode" select="$FormData"/>
							<xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
					</table>	
					<br/>
					<!-- Page 2 separated table -->
					<xsl:if test="$shouldSeparateP2">
						<br/>
						<br/>
						<span class="styRepeatingDataTitle"/>
						<table style="display:table;border-collapse:collapse;">
							<thead class="styTableThead" style="height:auto;">
								<tr>
									<th scope="col" style="width:5mm;font-weight:normal;"></th>
									<th class="styTableCellHeader" scope="col" style="width:90mm;font-weight:normal;">
										<strong>(a)</strong> 
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;">
										<strong>(b)</strong> 
									</th>
									<th class="styTableCellHeader" scope="col" colspan="5" style="width:86mm;font-weight:normal;">
										<strong>(c)</strong>
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;">
										<strong>(d)</strong>
									</th>
									<th class="styTableCellHeader" scope="col" style="width:25mm;font-weight:normal;border-right-width:0px;">
										<strong>(e)</strong> 
									</th>
								</tr>
							</thead>
							<thead>
								<tr>
									<th scope="col" rowspan="2" style="width:4mm;font-weight:normal;"></th>
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:90mm;">
											Description of distributed property <br/> (If applicable, include property code. See Pub. 946, Appendix B)
									</th>	
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:25mm;">
										Partnership’s basis in distributed property immediately before the distribution  
									</th>
									<th class="styIRS7217TableCellHeader" scope="col" colspan="5" style="width:86mm;f">
										Check applicable box(es) below. See instructions.		
									</th>
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:25mm;">
										FMV of distributed property 
									</th>
									<th class="styIRS7217TableCellHeader" scope="col" rowspan="2" style="width:25mm;font-weight:normal;border-right-width:0px;">
										Partner’s basis in distributed property after application of section 732 
									</th>
								</tr>
								<tr style="height:8mm;vertical-align:top;">
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(i)</strong> 732(d)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(ii)</strong> 732(f)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(iii)</strong> 734(b)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:17mm;font-weight:normal;">
											<strong>(iv)</strong>  743(b)
									</th>
									<th class="styTableCellHeader" scope="col" style="width:18mm;font-weight:normal;">
											<strong>(v)</strong> Reserved for future use
									</th>
								</tr>		
							</thead>
							<tbody style="font-size:6pt;">
								<xsl:for-each select="$FormData/AllocationBssDistriPropGrp">
									<tr style="height:5mm;">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
												<xsl:otherwise>styDepTblRow2</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>
										<td class="styTableCellTextInherit">
											<span style="width:5mm;font-weight:bold;padding-bottom:0mm;
												padding-left:.5mm;vertical-align:top;">
												<xsl:number format="1" value="position()"/>
											</span>
										</td>
										<td class="styTableCellCtrInherit">
											<xsl:call-template name="PopulateText">
												<xsl:with-param name="TargetNode" select="PropertyDesc"/>
											</xsl:call-template>
										</td>
										<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PrtshpBasisPropBfrDistriAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect732dBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="732(d) basis adjustment">
															<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 732(d) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect732dBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect732dBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect732fBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="732(f) basis adjustment">
																		<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 732(f) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect732fBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect732fBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect734bBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="734(b) basis adjustment">
																		<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 734(b) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect734bBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect734bBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit">
												<xsl:choose>
													<xsl:when test="Sect743bBasisAdjInd">
														<input class="styCkbox" type="checkbox" aria-label="743(b) basis adjustment">
																		<xsl:attribute name="aria-label">row <xsl:value-of select="position()"/> 743(b) basis adjustment</xsl:attribute>
															<xsl:call-template name="PopulateCheckbox">
																<xsl:with-param name="TargetNode" select="Sect743bBasisAdjInd"/>
																<xsl:with-param name="BackupName">IRS7217Sect743bBasisAdjInd</xsl:with-param>
															</xsl:call-template>
														</input>
													</xsl:when>
												</xsl:choose>
											</td>
											<td class="styTableCellCtrInherit" style="background-color:lightgrey;">
												<span style="width:1px;"/>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="DistributedPropertyFMVAmt"/>
												</xsl:call-template>
											</td>
											<td class="styTableCellAmtInherit">
												<xsl:call-template name="PopulateAmount">
													<xsl:with-param name="TargetNode" select="PrtnrBssPropAftrSect732Amt"/>
												</xsl:call-template>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:if>
				</form>
			</body>
		</html>
	</xsl:template>
	<!-- FillTable10Cols -->
	<xsl:template name="FillTable10Cols">
		<xsl:param name="LineNumber"/>
		<xsl:param name="SepMessage" select="false()"/>
		<xsl:param name="MaxLine" select="30"/>
		<xsl:param name="RowID" select="true()"/>
		<tr style="height:5mm;">
			<xsl:if test="$LineNumber &lt; 10">
				<td class="styLNLeftNumBoxSD" style="width:5mm;">
					<xsl:choose>
						<xsl:when test="not($RowID)">&nbsp;</xsl:when>
						<xsl:when test="$SepMessage">1</xsl:when>
						<xsl:otherwise>
							<xsl:number value="$LineNumber" format="1"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:if>
			<xsl:if test="$LineNumber &gt; 9">
				<td class="styLNLeftNumBox" style="width:5mm;">
					<xsl:choose>
						<xsl:when test="not($RowID)">&nbsp;</xsl:when>
						<xsl:when test="$SepMessage">1</xsl:when>
						<xsl:otherwise>
							<xsl:number value="$LineNumber" format="1"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:if>
			<td class="styTableCellTextInherit">
				<xsl:choose>
					<xsl:when test="$SepMessage">
						See Additional <br/> Data Table
					</xsl:when>
					<xsl:otherwise>&nbsp;</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellCtrInherit">
				<xsl:choose>
					<xsl:when test="Sect732dBasisAdjInd">
						<input class="styCkbox" type="checkbox" aria-label="732(d) basis adjustment">
							<xsl:attribute name="aria-label">row <xsl:value-of select="$LineNumber"/> 732(d) basis adjustment</xsl:attribute>
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="Sect732dBasisAdjInd"/>
								<xsl:with-param name="BackupName">IRS7217Sect732dBasisAdjInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</xsl:when>
				</xsl:choose>
			</td>
			<td class="styTableCellCtrInherit">
				<xsl:choose>
					<xsl:when test="Sect732fBasisAdjInd">
						<input class="styCkbox" type="checkbox" aria-label="732(f) basis adjustment">
							<xsl:attribute name="aria-label">row <xsl:value-of select="$LineNumber"/> 732(f) basis adjustment</xsl:attribute>
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="Sect732fBasisAdjInd"/>
								<xsl:with-param name="BackupName">IRS7217Sect732fBasisAdjInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</xsl:when>
				</xsl:choose>
			</td>
			<td class="styTableCellCtrInherit">
				<xsl:choose>
					<xsl:when test="Sect734bBasisAdjInd">
						<input class="styCkbox" type="checkbox" aria-label="734(b) basis adjustment">
							<xsl:attribute name="aria-label">row <xsl:value-of select="$LineNumber"/> 734(b) basis adjustment</xsl:attribute>
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="Sect734bBasisAdjInd"/>
								<xsl:with-param name="BackupName">IRS7217Sect734bBasisAdjInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</xsl:when>
				</xsl:choose>
			</td>
			<td class="styTableCellCtrInherit">
				<xsl:choose>
					<xsl:when test="Sect743bBasisAdjInd">
						<input class="styCkbox" type="checkbox" aria-label="743(b) basis adjustment">
							<xsl:attribute name="aria-label">row <xsl:value-of select="$LineNumber"/> 743(b) basis adjustment</xsl:attribute>
							<xsl:call-template name="PopulateCheckbox">
								<xsl:with-param name="TargetNode" select="Sect743bBasisAdjInd"/>
								<xsl:with-param name="BackupName">IRS7217Sect743bBasisAdjInd</xsl:with-param>
							</xsl:call-template>
						</input>
					</xsl:when>
				</xsl:choose>
			</td>
			<td class="styTableCellCtrInherit" style="background-color:lightgrey;">
				<span style="width:1px;"/>
			</td>
			<td class="styTableCellAmtInherit">&nbsp;</td>
			<td class="styTableCellAmtInherit" style="border-right-width:0px;">&nbsp;</td>
		</tr>
		<xsl:choose>
			<xsl:when test="$SepMessage">
				<xsl:call-template name="FillTable10Cols">
					<xsl:with-param name="LineNumber" select="2"/>
					<xsl:with-param name="SepMessage" select="false()"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
					<xsl:with-param name="RowID" select="$RowID"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$LineNumber &lt; $MaxLine">
			<xsl:attribute name="aria-label">row <xsl:value-of select="$LineNumber"/> 732(d) basis adjustment</xsl:attribute>
				<xsl:call-template name="FillTable10Cols">
					<xsl:with-param name="LineNumber" select="$LineNumber + 1"/>
					<xsl:with-param name="MaxLine" select="$MaxLine"/>
					<xsl:with-param name="RowID" select="$RowID"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>